<?php
include_once "inc/common.php";

// --------------------------------
// Check Login Status
// --------------------------------
$s_m_idx  = $_SESSION[SESSION_ID."_idx"];
$s_m_id   = $_SESSION[SESSION_ID."_id"];
$s_m_name = $_SESSION[SESSION_ID."_name"];

// --------------------------------
// Cart Count
// --------------------------------
if (! empty($_SESSION["shopping_cart"])) {
	$cart_count = count(array_keys($_SESSION["shopping_cart"]));
}

// --------------------------------
// Get Training information
// --------------------------------
$SQL = "SELECT * FROM training WHERE tr_open = 'Open' ORDER BY tr_order ASC; ";
$Result = mysqli_query($conn, $SQL);

$i = 0;
while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {

	$db_tr_idx[$i]        = $ResultsRow[tr_idx];
	$db_tr_date[$i]       = stripslashes($ResultsRow[tr_date]);
	$db_tr_webex[$i]      = stripslashes($ResultsRow[tr_webex]);
	$db_tr_instructor[$i] = stripslashes($ResultsRow[tr_instructor]);
	$db_tr_instructor_pic[$i] = stripslashes($ResultsRow[tr_instructor_pic]);
	$db_tr_title[$i] = stripslashes($ResultsRow[tr_title]);
	$db_tr_desc[$i] = stripslashes($ResultsRow[tr_desc]);
	$db_tr_cost[$i] = stripslashes($ResultsRow[tr_cost]);
	$db_tr_open[$i] = stripslashes($ResultsRow[tr_open]);
	$db_tr_cat[$i] = stripslashes($ResultsRow[tr_cat]);
	$db_tr_oder[$i] = stripslashes($ResultsRow[tr_oder]);
	$db_tr_overview_link[$i] = stripslashes($ResultsRow[tr_overview_link]);
	$db_tr_duration[$i] = stripslashes($ResultsRow[tr_duration]);
	$i ++;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
<!--
New Event
http://www.templatemo.com/tm-486-new-event
-->
<title>KIOSC - Korean Incubating Organization for Small Churches</title>
<meta name="description" content="">
<meta name="author" content="">
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
<link rel="icon" href="favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="css/bootstrap.min.css">
<link rel="stylesheet" href="css/animate.css">
<link rel="stylesheet" href="css/font-awesome.min.css">
<link rel="stylesheet" href="css/owl.theme.css">
<link rel="stylesheet" href="css/owl.carousel.css">

<!-- Main css -->
<link rel="stylesheet" href="css/style_bz_training.css">

<!-- Google Font -->
<link href='https://fonts.googleapis.com/css?family=Poppins:400,500,600' rel='stylesheet' type='text/css'>

<!-- for Random Background images for the Intro -->
<?php
$bg = array('training-bg.jpg'); // array of filenames

$i = rand(0, count($bg) - 1); // generate random number size of the array
$selectedBg = "$bg[$i]"; // set variable equal to which random filename was chosen
?>


</head>
<body data-spy="scroll" data-offset="50" data-target=".navbar-collapse">

	<!-- =========================
     PRE LOADER
============================== -->
	<div class="preloader">
		<div class="sk-rotating-plane"></div>
	</div>

	<!-- =========================
     NAVIGATION LINKS
============================== -->
	<div class="navbar navbar-fixed-top custom-navbar" role="navigation">
		<div class="container">

			<!-- navbar header -->
			<div class="navbar-header">
				<button class="navbar-toggle" data-toggle="collapse"
					data-target=".navbar-collapse">
					<span class="icon icon-bar"></span> <span class="icon icon-bar"></span>
					<span class="icon icon-bar"></span>
				</button>
				<div style="padding-top: 11px;">
					<img src="./images/logo_bnw.png" height="45">
				</div>
			</div>

			<div class="collapse navbar-collapse">

				<ul class="nav navbar-nav navbar-right">
					<li><a href="#intro" class="smoothScroll">Home</a></li>
					<li><a href="#membercommunity" class="smoothScroll">Introduction</a></li>
					<li><a href="#program" class="smoothScroll">Training Program</a></li>
					<li><a href="#contact" class="smoothScroll">Contact</a></li>
				<?php
					// Login Status (False)
					if ($s_m_name == "") {
				?>
					<li>
						<div style="padding-top: 17px; padding-left: 15px;">
							<button class="btn btn-sm btn-primary callLogin">Log In</button>
						</div>
					</li>
					<li><a href="#register" class="smoothScroll">Membership!</a></li>

				<?php
					// Login Status (True)
					} else if ($s_m_name != "") {
				?>
		  			<li>
						<div style="padding-top: 17px; padding-left: 15px;">
							<button class="btn btn-sm btn-primary callLogin" data-profile="profile" data-midx="<?=$s_m_idx?>">Welcome! <?=$s_m_name?></button>
						</div>
					</li>
					<li>
						<div style="padding-top: 17px; padding-left: 15px;">
							<button class="btn btn-sm btn-warning addtocart">
								<i class="fa fa-shopping-cart"></i> Cart <span id="counter" class="badge badge-light"><?=$cart_count?></span>
							</button>
						</div>
					</li>
				<? } ?>
				</ul>

			</div>
		</div>
	</div>


<!-- =========================
	INTRODUCTION SECTION
============================== -->
	<section id="membercommunity" class="parallax-section">
		<div class="container">
			<div class="row">
				<br>
				<br>
				<div class="wow fadeInLeft col-md-offset-1 col-md-6 col-sm-8" data-wow-delay="0.9s">
					<h2>PROFESSIONAL TRAINING!</h2>
					<p>KIOSC offers training courses for various professional topics,
						designed to expand and sharpen your skills towards a more
						successful career. Improvements that can benefit you in taking
						that next step.</p>
					<h2>LIFESTYLE!</h2>
					<p>KIOSC offers courses aimed towards the advancement of your own
						personal life and well-being. Enrich your skills in life by taking
						classes that can range anywhere from languages and cooking to
						health and happiness.</p>
					<h2>ENTERTAINMENTS!</h2>
					<p>Enjoy live performances and concerts. View live broadcasts from
						industry influencers. All streamed right here onto KIOSC's Campus
						platform.</p>
				</div>

			</div>
		</div>
	</section>


<!-- =========================
	TRAINING SECTION
============================== -->
	<section id="program" class="parallax-section">
		<div class="container">
			<div class="row">

				<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.6s">
					<div class="section-title">
						<h2>Open Online Training</h2>
						<p>Quisque ut libero sapien. Integer tellus nisl, efficitur sed
							dolor at, vehicula finibus massa. Sed tincidunt metus sed
							eleifend suscipit.</p>
					</div>
				</div>

				<div class="wow fadeInUp col-md-10 col-sm-10" data-wow-delay="0.9s">
					<!-- Nav tabs -->
					<ul class="nav nav-tabs" role="tablist">
						<li class="active"><a href="#fday" aria-controls="fday" role="tab" data-toggle="tab">Greg Hockel, Ph.D.</a></li>
						<li><a href="#sday" aria-controls="sday" role="tab" data-toggle="tab">Dan Sfera</a></li>
						<li><a href="#tday" aria-controls="tday" role="tab" data-toggle="tab">ENTERTAINMENTS!</a></li>
					</ul>
					<!-- tab panes -->
					<div class="tab-content">

						<div role="tabpanel" class="tab-pane active" id="fday">
						<?php
						for ($i = 0; $i < count($db_tr_idx); $i ++) {
						?>

						<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="<?=$db_tr_instructor_pic[$i]?>" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> <?=$db_tr_date[$i]?></span>
									<span><i class="fa fa-map-marker"></i> <a href="<?=$db_tr_webex[$i]?>" target="_blank">WebEx - <?=$db_tr_webex[$i]?></a></span>
								</h6>
								<h3><?=$db_tr_title[$i]?></h3>
								<h4>By <?=$db_tr_instructor[$i]?></h4>
								<p><?=$db_tr_desc[$i]?></p>
								<h4>* Cost: $<?=$db_tr_cost[$i]?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* Duration: <?=$db_tr_duration[$i]?></h4>

								<!-- Add to Cart Button -->
								<button type="button" class="btn btn-primary addtocart" data-tridx="<?=$db_tr_idx[$i]?>" data-trcost="<?=$db_tr_cost[$i]?>">Add to Cart</button>
							</div>

							<!-- program divider -->
							<div class="program-divider col-md-12 col-sm-12"></div>

						<? } ?>
						</div>
						<!-- End Training -->



						<div role="tabpanel" class="tab-pane" id="sday">
							<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="images/program-img4.jpg" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> 11.00 AM</span> <span><i class="fa fa-map-marker"></i> Room 240</span>
								</h6>
								<h3>Backend Development</h3>
								<h4>By Matt Lee</h4>
								<p>Integer rutrum viverra magna, nec ultrices risus rutrum nec.
									Pellentesque interdum vel nisi nec tincidunt. Quisque facilisis
									scelerisque venenatis. Nam vulputate ultricies luctus.</p>
							</div>

							<!-- program divider -->
							<div class="program-divider col-md-12 col-sm-12"></div>

							<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="images/program-img5.jpg" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> 01.00 PM</span> <span><i class="fa fa-map-marker"></i> Room 450</span>
								</h6>
								<h3>Web Application Lite</h3>
								<h4>By David Orlando</h4>
								<p>Aliquam faucibus lobortis dolor, id pellentesque eros pretium
									in. Aenean in erat ut quam aliquet commodo. Vivamus aliquam
									pulvinar ipsum ut sollicitudin. Suspendisse quis sollicitudin
									mauris.</p>
							</div>

							<!-- program divider -->
							<div class="program-divider col-md-12 col-sm-12"></div>

							<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="images/program-img6.jpg" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> 03.00 PM</span> <span><i class="fa fa-map-marker"></i> Room 650</span>
								</h6>
								<h3>Professional UX Design</h3>
								<h4>By James Lee Mark</h4>
								<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed
									diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna
									aliquam erat volutpat.</p>
							</div>
						</div>

						<div role="tabpanel" class="tab-pane" id="tday">
							<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="images/program-img7.jpg" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> 03.00 PM</span> <span><i class="fa fa-map-marker"></i> Room 750</span>
								</h6>
								<h3>Online Shopping Business</h3>
								<h4>By Michael Walker</h4>
								<p>Aliquam faucibus lobortis dolor, id pellentesque eros pretium
									in. Aenean in erat ut quam aliquet commodo. Vivamus aliquam
									pulvinar ipsum ut sollicitudin. Suspendisse quis sollicitudin
									mauris.</p>
							</div>

							<!-- program divider -->
							<div class="program-divider col-md-12 col-sm-12"></div>

							<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="images/program-img8.jpg" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> 05.00 PM</span> <span><i class="fa fa-map-marker"></i> Room 850</span>
								</h6>
								<h3>Introduction to Mobile App</h3>
								<h4>By Cherry Stella</h4>
								<p>Nunc eu nibh vel augue mollis tincidunt id efficitur tortor.
									Sed pulvinar est sit amet tellus iaculis hendrerit. Mauris
									justo erat, rhoncus in arcu at, scelerisque tempor erat.</p>
							</div>

							<!-- program divider -->
							<div class="program-divider col-md-12 col-sm-12"></div>

							<!-- program speaker here -->
							<div class="col-md-2 col-sm-2">
								<img src="images/program-img9.jpg" class="img-responsive" alt="program">
							</div>
							<div class="col-md-10 col-sm-10">
								<h6>
									<span><i class="fa fa-clock-o"></i> 07.00 PM</span> <span><i class="fa fa-map-marker"></i> Room 750</span>
								</h6>
								<h3>Bootstrap UI Design</h3>
								<h4>By John David</h4>
								<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed
									diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna
									aliquam erat volutpat.</p>
							</div>
						</div>

					</div>

				</div>
			</div>

	</section>


<!-- =========================
	MEMBERSHIP SECTION
============================== -->
	<section id="faq" class="parallax-section">
		<div class="container">
			<div class="row">

				<!-- Section title
			================================================== -->
				<div class="wow bounceIn col-md-offset-2 col-md-8 col-sm-offset-1 col-sm-10 text-center">
					<div class="section-title">
						<h2>Membership!</h2>
						<p>Join the KIOSC Community and benefit from a range of services
							to enhance your capabilities and that of your organization. Reach
							out and connect with other compatible businesses under the KIOSC
							umbrella with our Corporate Matching database. Or take courses
							through our online learning platform KIOSC Campus to boost your
							skills within your industry, career, or for your own personal
							growth. Elevate your brand and online image by gaining access to
							KIOSC Marketing.</p>

						<small style="color: #fca103;">* A portion of all membership dues
							goes towards KIOSC Support – a subdivision of KIOSC that provides
							support and incubation for small churches.<br> * prices will vary
							by each individual KIOSC Campus Course
						</small>

					</div>
				</div>
			<!-- Row -->
		</div>
	</section>


	<!-- =========================
   MEMBER SECTION
============================== -->
	<section id="register" class="parallax-section">
		<div class="container">
			<div class="row">

				<div class="wow fadeInUp col-md-7 col-sm-7" data-wow-delay="0.6s">
					<h2>Membership!</h2>
					<h3>Individual Member Benefits</h3>
					<p>- Full Access to KIOSC Contents</p>
					<p>- Open Free Online Seminar/Training</p>
					<p>- Exclusive Offers from KIOSC Partner</p>

					<h3>Business Member Benefits</h3>
					<p>- Includes All Individual Benefits</p>
					<p>- Discount rate for KIOSC Services</p>
					<p>- Networking with Business Members</p>
					<p>- Free Banner in KIOSK Website</p>
					<br>
					<div class="wow fadeInUp col-md-5 col-sm-5" data-wow-delay="1.4s">
						<a href="membership.php" class="btn btn-lg btn-danger smoothScroll wow fadeInUp" data-wow-delay="0.7s">Register Membership</a>
					</div>

				</div>

				<div class="wow fadeInUp col-md-5 col-sm-5" data-wow-delay="1s">
					<p>Contents here!</p>

				</div>

				<div class="col-md-1"></div>

			</div>
		</div>
	</section>


	<!-- =========================
	CONTACT SECTION
============================== -->
	<section id="contact" class="parallax-section">
		<div class="container">
			<div class="row">

				<div class="wow fadeInUp col-md-offset-1 col-md-5 col-sm-6" data-wow-delay="0.6s">
					<div class="contact_des">
						<h3>Contact Us!</h3>
						<p>Proin sodales convallis urna eu condimentum. Morbi tincidunt
							augue eros, vitae pretium mi condimentum eget. Suspendisse eu
							turpis sed elit pretium congue.</p>
						<p>Mauris at tincidunt felis, vitae aliquam magna. Sed aliquam
							fringilla vestibulum. Praesent ullamcorper mauris fermentum
							turpis scelerisque rutrum eget eget turpis.</p>
						<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed
							diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna
							aliquam erat volutpat. Lorem ipsum dolor.</p>
					</div>
				</div>

				<div class="wow fadeInUp col-md-5 col-sm-6" data-wow-delay="0.9s">
					<div class="contact_detail">
						<div class="section-title">
							<h2>Keep in touch</h2>
						</div>
						<form action="#" method="post">
							<input name="name" type="text" class="form-control" id="name" placeholder="Name">
							<input name="email" type="email" class="form-control" id="email" placeholder="Email">
							<textarea name="message" rows="5" class="form-control" id="message" placeholder="Message"></textarea>
							<div class="col-md-6 col-sm-10">
								<input name="submit" type="submit" class="form-control" id="submit" value="SEND">
							</div>
						</form>
					</div>
				</div>

			</div>
		</div>
	</section>

	<!------------------------->
	<!-- Shopping Cart Modal -->
	<!------------------------->
	<div class="modal fade" id="modal-data-edit">
		<div class="modal-dialog" id="custom-modal">
			<div class="modal-content">
				<div class="modal-header" style="background-color: #0480be; color: white;">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<h4 class="modal-title" id="modaltitle"></h4>
				</div>
				<div class="modal-body" id="modal-data-edit-body"></div>
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>
	<!-- /.modal -->


	<!-- =========================
	FOOTER SECTION
============================== -->
	<footer>
		<div class="container">
			<div class="row">

				<div class="col-md-12 col-sm-12">
					<p class="wow fadeInUp" data-wow-delay="0.6s">Copyright &copy; 2020 KIOSC | Support: ePASS Solutions</p>

					<ul class="social-icon">
						<li><a href="#" class="fa fa-facebook wow fadeInUp" data-wow-delay="1s"></a></li>
						<li><a href="#" class="fa fa-twitter wow fadeInUp" data-wow-delay="1.3s"></a></li>
						<li><a href="#" class="fa fa-dribbble wow fadeInUp" data-wow-delay="1.6s"></a></li>
						<li><a href="#" class="fa fa-behance wow fadeInUp" data-wow-delay="1.9s"></a></li>
						<li><a href="#" class="fa fa-google-plus wow fadeInUp" data-wow-delay="2s"></a></li>
					</ul>

				</div>

			</div>
		</div>
	</footer>


	<!-- Back top -->
	<a href="#back-top" class="go-top"><i class="fa fa-angle-up"></i></a>


<!-- =========================
	 SCRIPTS
============================== -->
<script src="js/jquery.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.parallax.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/smoothscroll.js"></script>
<script src="js/wow.min.js"></script>
<script src="js/custom.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.10.20/js/dataTables.bootstrap.min.js"></script>

<script type="text/javascript">

$(document).ready(function(){


	//-------------------------------------------
	// Call Log in
	//-------------------------------------------
	$(document).on('click', 'button.callLogin', function(e){

		var midx = $(this).data('midx');
		var profile = $(this).data('profile');
		var modalHeader = "";

		if(profile == "profile") {
			modalHeader = "MEMBER PROFILE!";
		} else {
			modalHeader = "MEMBER LOGIN!";
		}

		logincall(midx,"",modalHeader);
 	});

	//-------------------------------------------
	// Call Login Modal
	//-------------------------------------------
	function logincall(midx,trcost,modaltitle) {

		$('#custom-modal').removeClass("modal-lg");

		var showEditModal = true;

		if(showEditModal){
			$.ajax({
				method : 'POST',
				url : './login.php',
				dataType : 'html',
				data: { 'm_idx' : midx, 'tr_cost' : trcost },
				success: function(data){
					$('#modaltitle').text(modaltitle);
					$('#modal-data-edit-body').html(data);
					$('#modal-data-edit').modal();
					$.each($('#modal-data-edit select'), function(i,v){
						$(v).select2();
					});
				},
				error: function(data){
				}
			});
		}
	}//editcall


	//-------------------------------------------
	// Add to Cart
	//-------------------------------------------
	$(document).on('click', 'button.addtocart', function(e){

		var tridx = $(this).data('tridx');
		var trcost = $(this).data('trcost');

		if(tridx == "") {
			editcall("","","SHOPPING CART!");
		} else {
			editcall(tridx,trcost,"SHOPPING CART!");
		}
	});

	//-------------------------------------------
	// Add to Cart Call
	//-------------------------------------------
	function editcall(tridx,trcost,modaltitle) {

		$('#custom-modal').addClass("modal-lg");

		var showEditModal = true;

		if(showEditModal){
			$.ajax({
				method : 'POST',
				url : './cart.php',
				//dataType : 'html',
				data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
				success: function(data){
					$('#modaltitle').text(modaltitle);
					$('#modal-data-edit-body').html(data);
					$('#modal-data-edit').modal();
					$.each($('#modal-data-edit select'), function(i,v){
						$(v).select2();
					});
				},
				error: function(data){
				}
			});
		}
	}//editcall


	//-------------------------------------------
	// Remove to Cart
	//-------------------------------------------
	$(document).on('click', 'button.btn-cart-remove', function(e){
		var _this = $(this);
		var _row  = _this.closest('tr.cart-item');
		var tr_idx = _row.data('trIdx');
		var cart_idx = _row.data('cartIdx');

		if(confirm('Remove cart item?')){
			$.ajax({
				method : 'POST',
				url : './data_process.php',
				dataType : 'json',
				data: { 'cartmode': 'deleteOne','tr_idx' : tr_idx, 'cart_idx' : cart_idx },
				success: function(data){
					if(data.complete == 'Yes'){
						_row.remove();
						// Total re cal
						var totalPrice = 0;
						$.each($('#cart tr.cart-item'), function(i,v){
							totalPrice += $(v).data('cost');
						});
						$('#cart span.cart_total_price').text(totalPrice);
						// cart recount
						var cartCount = $('ul.nav li button.addtocart span').text();
						$('ul.nav li button.addtocart span').text(cartCount - 1);

					}else{
						if(data.message != ''){
							alert(data.message);
						}else{
							alert('Cart item delete fail. Please try again.');
						}
					}
				},
				error: function(data){
					alert('Cart item delete fail. Please try again.');
				}
			});
		}

	});


});

</script>

</body>
</html>
