<?php
include_once  "./inc/common.php";

?>

<!--<!DOCTYPE html>-->
<html lang="en">
<head>
<title>KIOSC - Korean Incubating Organization for Small Churches</title>
<meta name="description" content="">
<meta name="author" content="">
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
<link rel="icon" href="favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="css/bootstrap.min.css">
<link rel="stylesheet" href="css/animate.css">
<link rel="stylesheet" href="css/font-awesome.min.css">
<link rel="stylesheet" href="css/owl.theme.css">
<link rel="stylesheet" href="css/owl.carousel.css">

<!-- Main css -->
<link rel="stylesheet" href="css/style_bz_training.css">

<!-- Google Font -->
<link href='https://fonts.googleapis.com/css?family=Poppins:400,500,600' rel='stylesheet' type='text/css'>

<!-- for Random Background images for the Intro -->
<?php
  $bg = array('training-bg.jpg'); // array of filenames

  $i = rand(0, count($bg)-1); // generate random number size of the array
  $selectedBg = "$bg[$i]"; // set variable equal to which random filename was chosen
?>

<!-- Intro background image -->
<style type="text/css">
#intro {
    background: url('./images/<?php echo $selectedBg; ?>') 50% 0 repeat-y fixed;
    -webkit-background-size: cover;
    background-size: cover;
    background-position: center center;
    color: #ffffff;
    display: -webkit-box;
    display: -webkit-flex;
     display: -ms-flexbox;
    display: flex;
    -webkit-box-align: center;
     -webkit-align-items: center;
      -ms-flex-align: center;
          align-items: center;
    height: 100vh;
    text-align: center;
}
</style>


</head>
<body data-spy="scroll" data-offset="50" data-target=".navbar-collapse">

<!-- =========================
     PRE LOADER
============================== -->
<div class="preloader">

	<div class="sk-rotating-plane"></div>

</div>


<!-- =========================
     NAVIGATION LINKS
============================== -->
<div class="navbar navbar-fixed-top custom-navbar" role="navigation">
	<div class="container">

		<!-- navbar header -->
		<div class="navbar-header">
			<button class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
				<span class="icon icon-bar"></span>
				<span class="icon icon-bar"></span>
				<span class="icon icon-bar"></span>
			</button>
            <div style="padding-top: 11px;">
                <img src="./images/logo_bnw.png" height="45">
            </div>
		</div>

		<div class="collapse navbar-collapse">

			<ul class="nav navbar-nav navbar-right">
				<li><a href="#intro" class="smoothScroll">Home</a></li>
        <li><a href="#membercommunity" class="smoothScroll">Introduction</a></li>
				<li><a href="#program" class="smoothScroll">Training Program</a></li>
				<li><a href="#contact" class="smoothScroll">Contact</a></li>
        <li>
          <div style="padding-top: 17px; padding-left: 15px;">
            <button class="btn btn-sm btn-primary callLogin">Log In</button>
          </div>
        </li>
        <li><a href="#register" class="smoothScroll">Sign Up!</a></li>
			</ul>

		</div>

	</div>
</div>


<!-- =========================
    INTRO SECTION
============================== -->
<section id="intro" class="parallax-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12 col-sm-12">
				<h2 class="wow fadeInUp" data-wow-delay="0.6s">
          <font color="69b6c9">
            KIOSC TOWN is an online platform <br><br>that contains all the services provided by KIOSC.<br><br>
          </font>
        </h2>
        <a href="#membercommunity" class="btn btn-lg btn-default smoothScroll wow fadeInUp hidden-xs" data-wow-delay="0.9s">More Details</a>

			</div>
		</div>
	</div>
</section>

<!-- =========================
    INTRODUCTION SECTION
============================== -->
<section id="membercommunity" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInLeft col-md-offset-1 col-md-6 col-sm-8" data-wow-delay="0.9s">
				<h2>PROFESSIONAL TRAINING!</h2>
				<p>KIOSC offers training courses for various professional topics, designed to expand and sharpen your skills towards a more successful career. Improvements that can benefit you in taking that next step.</p>
        <h2>LIFE STYLE!</h2>
        <p>KIOSC offers courses aimed towards the advancement of your own personal life and well-being. Enrich your skills in life by taking classes that can range anywhere from languages and cooking to health and happiness.</p>
        <h2>ENTERTAINMENTS!</h2>
        <p>Enjoy live performances and concerts. View live broadcasts from industry influencers. All streamed right here onto KIOSC's Campus platform.</p>
			</div>

		</div>
	</div>
</section>

<!-- =========================
    TRAINING SECTION
============================== -->
<section id="program" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.6s">
				<div class="section-title">
					<h2>Open Online Training/Seminar</h2>
					<p>Quisque ut libero sapien. Integer tellus nisl, efficitur sed dolor at, vehicula finibus massa. Sed tincidunt metus sed eleifend suscipit.</p>
				</div>
			</div>

			<div class="wow fadeInUp col-md-10 col-sm-10" data-wow-delay="0.9s">
				<!-- Nav tabs -->
				<ul class="nav nav-tabs" role="tablist">
					<li class="active"><a href="#fday" aria-controls="fday" role="tab" data-toggle="tab">PROFESSIONAL TRAINING!</a></li>
					<li><a href="#sday" aria-controls="sday" role="tab" data-toggle="tab">LIFE STYLE!</a></li>
					<li><a href="#tday" aria-controls="tday" role="tab" data-toggle="tab">ENTERTAINMENTS!</a></li>
				</ul>
				<!-- tab panes -->
				<div class="tab-content">

					<div role="tabpanel" class="tab-pane active" id="fday">
						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img1.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 09.00 AM</span>
								<span><i class="fa fa-map-marker"></i> Room 240</span>
							</h6>
							<h3>Introduction to Design</h3>
							<h4>By Jenny Green</h4>
							<p>Maecenas accumsan metus turpis, eu faucibus ligula interdum in. Mauris at tincidunt felis, vitae aliquam magna. Sed aliquam fringilla vestibulum.</p>

              <!-- Add to Cart Button -->
              <?
              $db_tr_idx = 1;
              $db_tr_cost = 340;
              ?>
              <button type="button" class="btn btn-primary addtocart" data-tridx="<?=$db_tr_idx?>"  data-trcost="<?=$db_tr_cost?>">Add to Cart</button>
            </div>

						<!-- program divider -->
						<div class="program-divider col-md-12 col-sm-12"></div>

						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img2.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 10.00 AM</span>
								<span><i class="fa fa-map-marker"></i> Room 360</span>
							</h6>
							<h3>Front-End Development</h3>
							<h4>By Johnathan Mark</h4>
							<p>Mauris at tincidunt felis, vitae aliquam magna. Sed aliquam fringilla vestibulum. Praesent ullamcorper mauris fermentum turpis scelerisque rutrum eget eget turpis.</p>

              <!-- Add to Cart Button -->
              <?
              $db_tr_idx = 2;
              $db_tr_cost = 240;
              ?>
              <button type="button" class="btn btn-primary addtocart" data-tridx="<?=$db_tr_idx?>"  data-trcost="<?=$db_tr_cost?>">Add to Cart</button>

						</div>

						<!-- program divider -->
						<div class="program-divider col-md-12 col-sm-12"></div>

						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img3.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 11.00 AM</span>
								<span><i class="fa fa-map-marker"></i> Room 450</span>
							</h6>
							<h3>Social Media Marketing</h3>
							<h4>By Johnathan Doe</h4>
							<p>Nam pulvinar, elit vitae rhoncus pretium, massa urna bibendum ex, aliquam efficitur lorem odio vitae erat. Integer rutrum viverra magna, nec ultrices risus rutrum nec.</p>
						</div>
					</div>

					<div role="tabpanel" class="tab-pane" id="sday">
						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img4.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 11.00 AM</span>
								<span><i class="fa fa-map-marker"></i> Room 240</span>
							</h6>
							<h3>Backend Development</h3>
							<h4>By Matt Lee</h4>
							<p>Integer rutrum viverra magna, nec ultrices risus rutrum nec. Pellentesque interdum vel nisi nec tincidunt. Quisque facilisis scelerisque venenatis. Nam vulputate ultricies luctus.</p>
						</div>

						<!-- program divider -->
						<div class="program-divider col-md-12 col-sm-12"></div>

						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img5.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 01.00 PM</span>
								<span><i class="fa fa-map-marker"></i> Room 450</span>
							</h6>
							<h3>Web Application Lite</h3>
							<h4>By David Orlando</h4>
							<p>Aliquam faucibus lobortis dolor, id pellentesque eros pretium in. Aenean in erat ut quam aliquet commodo. Vivamus aliquam pulvinar ipsum ut sollicitudin. Suspendisse quis sollicitudin mauris.</p>
						</div>

						<!-- program divider -->
						<div class="program-divider col-md-12 col-sm-12"></div>

						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img6.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 03.00 PM</span>
								<span><i class="fa fa-map-marker"></i> Room 650</span>
							</h6>
							<h3>Professional UX Design</h3>
							<h4>By James Lee Mark</h4>
							<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna aliquam erat volutpat.</p>
						</div>
					</div>

					<div role="tabpanel" class="tab-pane" id="tday">
						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img7.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 03.00 PM</span>
								<span><i class="fa fa-map-marker"></i> Room 750</span>
							</h6>
							<h3>Online Shopping Business</h3>
							<h4>By Michael Walker</h4>
							<p>Aliquam faucibus lobortis dolor, id pellentesque eros pretium in. Aenean in erat ut quam aliquet commodo. Vivamus aliquam pulvinar ipsum ut sollicitudin. Suspendisse quis sollicitudin mauris.</p>
						</div>

						<!-- program divider -->
						<div class="program-divider col-md-12 col-sm-12"></div>

						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img8.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 05.00 PM</span>
								<span><i class="fa fa-map-marker"></i> Room 850</span>
							</h6>
							<h3>Introduction to Mobile App</h3>
							<h4>By Cherry Stella</h4>
							<p>Nunc eu nibh vel augue mollis tincidunt id efficitur tortor. Sed pulvinar est sit amet tellus iaculis hendrerit. Mauris justo erat, rhoncus in arcu at, scelerisque tempor erat.</p>
						</div>

						<!-- program divider -->
						<div class="program-divider col-md-12 col-sm-12"></div>

						<!-- program speaker here -->
						<div class="col-md-2 col-sm-2">
							<img src="images/program-img9.jpg" class="img-responsive" alt="program">
						</div>
						<div class="col-md-10 col-sm-10">
							<h6>
								<span><i class="fa fa-clock-o"></i> 07.00 PM</span>
								<span><i class="fa fa-map-marker"></i> Room 750</span>
							</h6>
							<h3>Bootstrap UI Design</h3>
							<h4>By John David</h4>
							<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna aliquam erat volutpat.</p>
						</div>
					</div>

				</div>

		</div>
	</div>
</section>

<!-- =========================
   MEMBER SECTION
============================== -->
<section id="register" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-7 col-sm-7" data-wow-delay="0.6s">
				<h2>Membership Here</h2>
				<h3>Individual Member Benefits</h3>
				<p>- Full Access to KIOSC Contents</p>
				<p>- Open Free Online Seminar/Training</p>
				<p>- Exclusive Offers from KIOSC Partner</p>

                <h3>Business Member Benefits</h3>
				<p>- Includes All Individual Benefits</p>
				<p>- Discount rate for KIOSC Services</p>
				<p>- Networking with Business Members</p>
				<p>- Free Banner in KIOSK Website</p>

			</div>

			<div class="wow fadeInUp col-md-5 col-sm-5" data-wow-delay="1s">
				<form action="#" method="post">
					<input name="firstname" type="text" class="form-control" id="firstname" placeholder="First Name">
					<input name="lastname" type="text" class="form-control" id="lastname" placeholder="Last Name">
					<input name="phone" type="telephone" class="form-control" id="phone" placeholder="Phone Number">
					<input name="email" type="email" class="form-control" id="email" placeholder="Email Address">
					<div class="col-md-offset-6 col-md-6 col-sm-offset-1 col-sm-10">
						<input name="submit" type="submit" class="form-control" id="submit" value="REGISTER">
					</div>
				</form>
			</div>

			<div class="col-md-1"></div>

		</div>
	</div>
</section>


<!-- =========================
    VIDEO SECTION
============================== -->
<section id="video" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-6 col-sm-10" data-wow-delay="1.3s">
				<h2>Watch Video</h2>
				<h3>Quisque ut libero sapien. Integer tellus nisl, efficitur sed dolor at, vehicula finibus massa. Sed tincidunt metus sed eleifend suscipit.</h3>
				<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna aliquam erat volutpat. Lorem ipsum dolor sit amet consectetuer diam nonummy.</p>
			</div>
			<div class="wow fadeInUp col-md-6 col-sm-10" data-wow-delay="1.6s">
				<div class="embed-responsive embed-responsive-16by9">
					<iframe class="embed-responsive-item" src="https://www.youtube.com/embed/XDPwXQjAlB0" allowfullscreen></iframe>
				</div>
			</div>

		</div>
	</div>
</section>



<!-- =========================
    CONTACT SECTION
============================== -->
<section id="contact" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-offset-1 col-md-5 col-sm-6" data-wow-delay="0.6s">
				<div class="contact_des">
					<h3>Contact Us!</h3>
					<p>Proin sodales convallis urna eu condimentum. Morbi tincidunt augue eros, vitae pretium mi condimentum eget. Suspendisse eu turpis sed elit pretium congue.</p>
					<p>Mauris at tincidunt felis, vitae aliquam magna. Sed aliquam fringilla vestibulum. Praesent ullamcorper mauris fermentum turpis scelerisque rutrum eget eget turpis.</p>
					<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet. Dolore magna aliquam erat volutpat. Lorem ipsum dolor.</p>
					<a href="#" class="btn btn-danger">MEMBERSHIP</a>
				</div>
			</div>

			<div class="wow fadeInUp col-md-5 col-sm-6" data-wow-delay="0.9s">
				<div class="contact_detail">
					<div class="section-title">
						<h2>Keep in touch</h2>
					</div>
					<form action="#" method="post">
						<input name="name" type="text" class="form-control" id="name" placeholder="Name">
					  	<input name="email" type="email" class="form-control" id="email" placeholder="Email">
					  	<textarea name="message" rows="5" class="form-control" id="message" placeholder="Message"></textarea>
						<div class="col-md-6 col-sm-10">
							<input name="submit" type="submit" class="form-control" id="submit" value="SEND">
						</div>
					</form>
				</div>
			</div>

		</div>
	</div>
</section>

<!-- =========================
    FOOTER SECTION
============================== -->
<footer>
	<div class="container">
		<div class="row">

			<div class="col-md-12 col-sm-12">
				<p class="wow fadeInUp" data-wow-delay="0.6s">Copyright &copy; 2020 KIOSC

                    | Support: ePASS Solutions</p>

				<ul class="social-icon">
					<li><a href="#" class="fa fa-facebook wow fadeInUp" data-wow-delay="1s"></a></li>
					<li><a href="#" class="fa fa-twitter wow fadeInUp" data-wow-delay="1.3s"></a></li>
					<li><a href="#" class="fa fa-dribbble wow fadeInUp" data-wow-delay="1.6s"></a></li>
					<li><a href="#" class="fa fa-behance wow fadeInUp" data-wow-delay="1.9s"></a></li>
					<li><a href="#" class="fa fa-google-plus wow fadeInUp" data-wow-delay="2s"></a></li>
				</ul>

			</div>

		</div>
	</div>
</footer>

<!------------------------->
<!-- Shopping Cart Modal -->
<!------------------------->
<div class="modal fade" id="modal-data-edit">
   <div class="modal-dialog">
      <div class="modal-content">
	     <div class="modal-header" style="background-color: #0480be; color:white;">
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
			<span aria-hidden="true">&times;</span>
		    </button>
		    <h4 class="modal-title" id="modaltitle"></h4>
	     </div>
	     <div class="modal-body" id="modal-data-edit-body"></div>
      </div>
      <!-- /.modal-content -->
   </div>
   <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Back top -->
<a href="#back-top" class="go-top"><i class="fa fa-angle-up"></i></a>


<!-- =========================
     SCRIPTS
============================== -->
<script src="js/jquery.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.parallax.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/smoothscroll.js"></script>
<script src="js/wow.min.js"></script>
<script src="js/custom.js"></script>

<script>

$(document).ready(function(){


  //-------------------------------------------
  // Call Log in
  //-------------------------------------------
  $(document).on('click', 'button.callLogin', function(e){
    logincall("","","MEMBER LOGIN!");
  });

  //-------------------------------------------
  // Call Login Modal
  //-------------------------------------------
  function logincall(tridx,trcost,modaltitle) {

      var showEditModal = true;

      if(showEditModal){
        $.ajax({
          method : 'POST',
          url : './login.php',
          dataType : 'html',
          data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
          success: function(data){
            $('#modaltitle').text(modaltitle);
            $('#modal-data-edit-body').html(data);
            $('#modal-data-edit').modal();
            $.each($('#modal-data-edit select'), function(i,v){
              $(v).select2();
            });
          },
          error: function(data){

          }
        });
      }
    }//editcall


  //-------------------------------------------
  // Add to Cart
  //-------------------------------------------
  $(document).on('click', 'button.addtocart', function(e){

    var tridx = $(this).data('tridx');
    var trcost = $(this).data('trcost');
    editcall(tridx,trcost,"SHOPPING CART!");

  });

  //-------------------------------------------
  // Add to Cart Call
  //-------------------------------------------
  function editcall(tridx,trcost,modaltitle) {

      var showEditModal = true;

      if(showEditModal){
        $.ajax({
          method : 'POST',
          url : './cart.php',
          dataType : 'html',
          data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
          success: function(data){
            $('#modaltitle').text(modaltitle);
            $('#modal-data-edit-body').html(data);
            $('#modal-data-edit').modal();
            $.each($('#modal-data-edit select'), function(i,v){
              $(v).select2();
            });
          },
          error: function(data){

          }
        });
      }
    }//editcall
});

</script>

</body>
</html>
