<?

// --------------------------------
// Training set date
// --------------------------------
$page_split = 3; // pageing line count

// --------------------------------
// Get Instructor list
// --------------------------------
$training_category = array();
$SQL = " SELECT cd.*, COUNT(tr_idx) AS tr_cnt ";
$SQL.= " FROM common_data cd ";
$SQL.= " LEFT OUTER JOIN ( ";
$SQL.= "     SELECT tr.tr_idx, tr.tr_cat ";
$SQL.= "     FROM training tr ";
$SQL.= "     LEFT OUTER JOIN instructor ir ON ir.ir_idx = tr.tr_ir_idx ";
$SQL.= "     WHERE tr.tr_open   = 'Open' ";
$SQL.= "     AND   ir.ir_active = 'Y' ";
$SQL.= " ) ti ON ti.tr_cat = cd.cd_idx ";
$SQL.= " WHERE cd.cd_use  = 'Y' ";
$SQL.= " AND   cd.cd_type = 'training_category' ";
$SQL.= " GROUP BY cd_idx, cd_type, cd_name, cd_date, cd_use, cd_rel_info, cd_order ";
$SQL.= " ORDER BY cd.cd_order ASC ";
$Result = mysqli_query($conn, $SQL);
while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($training_category, $ResultsRow);
}

// --------------------------------
// Get Training information
// --------------------------------
$training_list   = array();

$SQL = " SELECT tr.*, ir.* ";
$SQL.= " FROM training tr ";
$SQL.= " LEFT OUTER JOIN instructor ir ON ir.ir_idx = tr.tr_ir_idx ";
$SQL.= " WHERE tr.tr_open   = 'Open' ";
$SQL.= " AND   ir.ir_active = 'Y' ";
$SQL.= " ORDER BY ir.ir_order ASC, tr.tr_order ASC ";
$Result = mysqli_query($conn, $SQL);

while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($training_list, $ResultsRow);
}

?>

<!-- =========================
	TRAINING SECTION
============================== -->
<section id="program" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.6s">
				<div class="section-title">
					<h2>Drug Development</h2>
					<p></p>
				</div>
			</div>

			<div class="wow fadeInUp col-md-10 col-sm-10" data-wow-delay="0.9s">
				<!-- Nav tabs -->
				<ul class="nav nav-tabs" role="tablist">
				<?
				for ($cdi=0; $cdi < count($training_category); $cdi++) {
					if($training_category[$cdi][tr_cnt] > 0){
				?>
					<li class="<?=$cdi == 0 ? "active" : "" ?>">
						<a href="#ir_content_<?=$training_category[$cdi][cd_order]?>" aria-controls="ir_content_<?=$training_category[$cdi][cd_order]?>" role="tab" data-toggle="tab">
							<?=$training_category[$cdi][cd_name]?>
						</a>
					</li>
				<?
					}
				}
				?>
					<!-- <li class="active"><a href="#tday" aria-controls="tday" role="tab" data-toggle="tab">ENTERTAINMENTS!</a></li> -->
				</ul>
				<!-- tab panes -->
				<div class="tab-content">
				<?
				for ($cdi=0; $cdi < count($training_category); $cdi++) {
					if($training_category[$cdi][tr_cnt] > 0){
				?>
					<div role="tabpanel" class="tab-pane <?=$cdi == 0 ? "active" : "" ?>" id="ir_content_<?=$training_category[$cdi][cd_order]?>">
						<div id="ir_carousel_<?=$training_category[$cdi][cd_order]?>" class="carousel slide" data-interval="false" data-wrap="false" data-keyboard="false">

							<div class="row">
								<div class="col-md-12 col-sm-12">
									<h3>Instructor Information</h3>
								</div>
								<div class="col-md-2 col-sm-2">
									<img src="<?=$training_list[$cdi][ir_picture]?>" class="img-responsive" alt="program">
									<h4><?=$training_list[$cdi][ir_name]?></h4>
								</div>
								<div class="col-md-10 col-sm-10">
									<?=$training_list[$cdi][ir_desc]?>
									<br><br><br>
								</div>
							</div>

						<?
						$page_content_cnt = 0;
						$carousel_inner_open = false;
						$carousel_item_open  = false;

						for ($tr=0; $tr < count($training_list); $tr++) {

							if($training_list[$tr][tr_ir_idx] == $training_category[$cdi][cd_order]){

								if($page_content_cnt == 0 && !$carousel_inner_open){
									$carousel_inner_open = true;
									echo '<div class="carousel-inner" role="listbox">';
								}
								if($page_content_cnt % $page_split == 0 && !$carousel_item_open){
									$carousel_item_open = true;
									echo '<div class="item '.($page_content_cnt == 0 ? 'active' : '').'">';
								}
						?>
							<!-- program speaker here -->
							<!--
							<div class="col-md-2 col-sm-2">
								<img src="<?=$training_list[$tr][ir_picture]?>" class="img-responsive" alt="program">
							</div>
						-->
							<div class="col-md-12 col-sm-12">
								<h3><?=$training_list[$tr][tr_title]?></h3>
								<h6>
									<span><i class="fa fa-clock-o"></i> <?=$training_list[$tr][tr_date]?></span>
									<span>
										<i class="fa fa-map-marker"></i>
										<a href="<?=$training_list[$tr][tr_webex]?>" target="_blank">WebEx - <?=$training_list[$tr][tr_webex]?></a>
									</span>
								</h6>
								<p><?=$training_list[$tr][tr_desc]?></p>
								<h4>* Cost: $<?=$training_list[$tr][tr_cost]?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* Duration: <?=$training_list[$tr][tr_duration]?></h4>

								<!-- Add to Cart Button -->
								<button type="button" class="btn btn-primary addtocart" data-tridx="<?=$training_list[$tr][tr_idx]?>" data-trcost="<?=$training_list[$tr][tr_cost]?>">Add to Cart</button>
							</div>
						<?
							$page_content_cnt++;
							if( $page_content_cnt % $page_split != 0 && $page_content_cnt != $training_category[$cdi][tr_cnt] ){
								echo '<div class="program-divider col-md-12 col-sm-12"></div>';
							}

							if($page_content_cnt % $page_split == 0 && $carousel_item_open){
								$carousel_item_open = false;
								echo '</div><!-- end item -->'; // close div
							}

						} // check instructor training

					} // end for $training_list

					if($carousel_item_open){
						$carousel_item_open = false;
						echo '</div><!-- end item last -->'; // close div
					}

					if($carousel_inner_open){
						$carousel_inner_open = false;
						echo '</div><!-- end carousel-inner last -->'; // carousel-inner
					}

					if($page_content_cnt > $page_split){
					?>
						<div class="program-divider col-md-12 col-sm-12" style="margin-bottom: 10px;"></div>

						<!-- Indicators -->
						<div class="col-md-10 col-sm-10" style="text-align:center;">
							<nav aria-label="Page navigation carousel-indicators">
								<ul class="pagination">
									<li data-target="#ir_carousel_<?=$training_category[$cdi][cd_order]?>" data-slide="prev" class="page-item">
										<a class="page-link" aria-label="Previous">
											<span aria-hidden="true" style="padding-right:0px;">Prev</span>
										</a>
									</li>
									<?
									$total_page  = $training_category[$cdi][tr_cnt] / $page_split;
									// $total_page += $training_category[$cdi][tr_cnt] % $page_split == 0 ? 0 : 1;
									for ($pi=0; $pi < $total_page; $pi++) {
									?>
									<li data-target="#ir_carousel_<?=$training_category[$cdi][cd_order]?>" data-slide-to="<?=$pi?>" class="page-item"><a class="page-link"><?=($pi+1)?></a></li>
									<?
									}
									?>
									<li data-target="#ir_carousel_<?=$training_category[$cdi][cd_order]?>" data-slide="next" class="page-item">
										<a class="page-link" aria-label="Next">
											<span aria-hidden="true" style="padding-right:0px;">Next</span>
										</a>
									</li>
								</ul>
							</nav>
						</div>
					<? } ?>

					</div> <!-- end carousel -->

				</div> <!-- tabpanel  -->
				<?
					}
				}
				?>

		</div> <!-- end row -->
	</div> <!-- container -->
</section>



<script type="text/javascript">

$(document).ready(function(){


	//-------------------------------------------
	// Add to Cart
	//-------------------------------------------
	$(document).on('click', 'button.addtocart', function(e){

		var tridx = $(this).data('tridx');
		var trcost = $(this).data('trcost');

		if(tridx == "") {
			editcall("","","SHOPPING CART!");
		} else {
			editcall(tridx,trcost,"SHOPPING CART!");
		}
	});

	//-------------------------------------------
	// Add to Cart Call
	//-------------------------------------------
	function editcall(tridx,trcost,modaltitle) {

		$('#custom-modal').addClass("modal-lg");

		var showEditModal = true;

		if(showEditModal){
			$.ajax({
				method : 'POST',
				url : './cart.php',
				//dataType : 'html',
				data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
				success: function(data){
					$('#modaltitle').text(modaltitle);
					$('#modal-data-edit-body').html(data);
					$('#modal-data-edit').modal();
					$.each($('#modal-data-edit select'), function(i,v){
						$(v).select2();
					});
				},
				error: function(data){
				}
			});
		}
	}//editcall


});

</script>
