<?

// --------------------------------
// Training set date
// --------------------------------
$page_split = 12; // pageing line count


$instructor_info = array();
$instructor_info[2] = "<br/><br/>
<p>This course will give participants an understanding to US clinical site management and monitoring during studies at both the basic and advanced levels. (2 semesters completed in 2020)</p>
<p></p>
<p>Course List:</p>
<p style='padding-left:30px;'>* Basic I - GCP for Site Monitors</p>
<p style='padding-left:30px;'>* Basic II - Site Selection</p>
<p style='padding-left:30px;'>* Basic III - Site Initiation</p>
<p style='padding-left:30px;'>* Basic IV - Site Monitoring</p>
<p style='padding-left:30px;'>* Basic V - Site Close-out</p>
<p style='padding-left:30px;'>* Advanced I - Source Documents</p>
<p style='padding-left:30px;'>* Advanced II - Site Regulatory</p>
<p style='padding-left:30px;'>* Advanced III - Protocol Deviation Etc</p>
<p></p>
<p>The upcoming 2021 schedule for this course will be updated within the near future.</p>
";

$instructor_info[3] = "<br/><br/>
<p>This course will give participants an orientation into various clinical study statistical concepts and methodology to be used for clinical study data analysis. (2 semesters completed in 2020)</p>
<p></p>
<p>Course List:</p>
<p style='padding-left:30px;'>* Various Statistical Analysis Method I</p>
<p style='padding-left:30px;'>* Various Statistical Analysis Method II</p>
<p style='padding-left:30px;'>* Study Design and Power & Sample Size</p>
<p style='padding-left:30px;'>* Adaptive Trial Design</p>
<p></p>
<p>The upcoming 2021 schedule for this course will be updated within the near future.</p>
";


// --------------------------------
// Get Instructor list
// --------------------------------
$instructor_list = array();
$SQL = " SELECT ir.*, (SELECT COUNT(tr_idx) FROM training WHERE tr_ir_idx = ir.ir_idx) AS tr_cnt ";
$SQL.= " FROM instructor ir ";
$SQL.= " WHERE ir.ir_active = 'Y' ";
$SQL.= " ORDER BY ir.ir_order ASC ";
$Result = mysqli_query($conn, $SQL);
while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($instructor_list, $ResultsRow);
}

// --------------------------------
// Get Training information
// --------------------------------
$training_list   = array();

$SQL =" SELECT ";
$SQL.="       tr.*, ir.* ";
$SQL.="     , CASE WHEN tr.tr_open = 'Open'     THEN 1 ";
$SQL.="            WHEN tr.tr_open = 'Schedule' THEN 2 ";
$SQL.="            WHEN tr.tr_open = 'Close'    THEN 3 ";
$SQL.="            ELSE 9 ";
$SQL.="       END AS open_order ";
$SQL.=" FROM training tr ";
$SQL.=" LEFT OUTER JOIN instructor ir ON ir.ir_idx = tr.tr_ir_idx ";
$SQL.=" WHERE tr.tr_open IN ('Open', 'Schedule', 'Close') ";
$SQL.=" AND   ir.ir_active = 'Y' ";
$SQL.=" AND   tr.tr_flag1  NOT IN ('Event') ";
$SQL.=" ORDER BY ir.ir_order ASC, open_order ASC, tr.tr_order ASC ";
$Result = mysqli_query($conn, $SQL);

while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($training_list, $ResultsRow);
}

?>

<!-- ======================
	Free Private Seminar
=========================-->
<?php

// ---------------------------------------------
// Get Free Private Seminar Registered List
// ---------------------------------------------
$booking_list = array();
$SQL = " SELECT * FROM training_free_booking WHERE 1 ";
$Result = mysqli_query($conn, $SQL);
while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($booking_list, $ResultsRow);
}


$bookingcol_value = array("","APR 19 (MON)","APR 20 (TUE)","APR 21 (WED)","APR 22 (THU)","APR 23 (FRI)");
$bookingrow_value = array("10:00AM -10:45AM(KT)","11:00AM -11:45AM(KT)","12:00PM -12:45PM(KT)");

$_SESSION['bookingcol_value'] = $bookingcol_value;
$_SESSION['bookingrow_value'] = $bookingrow_value;

$booked_array = array(array());
$booked_data_array = array(array());

for($i=0; $i<=2; $i++) {
	for($j=0; $j<=5; $j++) {
		$booked_array[$i][$j] = "No";
		$booked_data_array[$i][$j] = "";
	}
}


if($s_m_idx=="548" || $s_m_idx=="326") {?>
	<br><br>
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.2s">

				<?

				for ($bk=0; $bk < count($booking_list); $bk++) {
					$booked_array[$booking_list[$bk][tfb_booktridx]][$booking_list[$bk][tfb_booktdidx]] = $booking_list[$bk][tfb_company];
					$booked_data_array[$booking_list[$bk][tfb_booktridx]][$booking_list[$bk][tfb_booktdidx]] = $booking_list[$bk][m_idx];
				}
				?>

				<h2>1 : 1 Q&A Session Register</h2>
				<table id="SeminarRegisterTable" class="table table-bordered table-hover">
					<thead>
						<tr style="background-color:#a6e0f5">
							<th>Time/Date</th>
							<th>APR 19 (MON)</th>
							<th>APR 20 (TUE)</th>
							<th>APR 21 (WED)</th>
							<th>APR 22 (THU)</th>
							<th>APR 23 (FRI)</th>
						</tr>
					</thead>
					<tbody>
						<?for($tri=0; $tri<=2; $tri++) {?>
							<tr>
								<?for($tdi=0; $tdi<=5; $tdi++) {?>
									<?if($tdi==0) {?>
											<td><?=$bookingrow_value[$tri];?></td>
										<?} else {?>
											<td data-booktridx="<?=$tri?>" data-booktdidx="<?=$tdi?>">
											<?if($booked_array[$tri][$tdi] == "No") {?>
												<button class="btn btn-sm btn-primary private-seminar-btn" data-midx=<?=$s_m_idx?> data-booktridx=<?=$tri?> data-booktdidx=<?=$tdi?>>Register</button>
											<?} else {?>
												<?if($booked_data_array[$tri][$tdi] == $s_m_idx ) {?>
													<small>Booked by</small><br>
													<b>
														<a href="javascript:void(0);" class="private-seminar-edit-btn" data-midx=<?=$s_m_idx?> data-booktridx=<?=$tri?> data-booktdidx=<?=$tdi?>><?=$booked_array[$tri][$tdi]?></a>
														<!-- <a href="#" onclick="javascript:registercall('<?=$tri?>','<?=$tdi?>','<?=$s_m_idx?>','Booking Information','edit');"><?=$booked_array[$tri][$tdi]?></a> -->
													</b>
												<?} else {?>
													<small>Booked by</small><br><b><?=$booked_array[$tri][$tdi]?></b>
												<?}?>
											<?}?>
											</td>
										<?}?>
								<?}?>
							</tr>
						<?}?>
					</tbody>
				</table>

			</div>
		</div>
	</div>

<?
}
?>





<!-- ======================
	Free Seminar
=========================-->
<!--
<br><br>
	<div class="container">
		<div class="row">
			<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.2s">
				<div class="section-title">
					<div class="alert alert-info">
						<br>
  					<strong>Free Seminar from KIOSC Training!</strong> <br><h3>Practical Aspects of Early Phase Regulatory Affairs in the US</h3>
						Hyungjoo (Hugh) Lee / CEO & Founder / KCRN Research<br><br>
						<b>Date:</b> 04/01/2021, Thursday 10:00AM (KST), 03/31/2021, Wednesday 9:00PM (EST)<br><br>
						<? if ($s_m_name != "") {
                            $event_tr_idx = "48";

                            $already_training = array();
                            $SQL = " SELECT * ";
                            $SQL.= " FROM payment          pm ";
                            $SQL.= " JOIN payment_training pt ON pt.pm_idx = pm.pm_idx ";
                            $SQL.= " WHERE pm.m_idx  = '$s_m_idx' ";
                            $SQL.= " AND   pt.tr_idx = '$event_tr_idx' ";
                            $Result = mysqli_query($conn, $SQL);
                            while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
                                $already_training = $ResultsRow;
                            }
                            if(empty($already_training)){
                                echo '<button class="btn btn-sm btn-primary free-seminar-btn">Register</button>';
                            }else{
                                echo '<button class="btn btn-sm btn-primary free-seminar-btn" disabled>Registered</button>';
                            }
                        ?>
						<?} else { ?>
							<button class="btn btn-sm btn-primary callLogin">Register</button>
						<? } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
-->


<!-- =========================
	TRAINING SECTION
============================== -->
<section id="program" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.5s">
				<div class="section-title">
					<h2>Drug Development</h2>
					<p></p>
				</div>
			</div>

			<div class="wow fadeInUp col-md-10 col-sm-10" data-wow-delay="0.6s">
				<!-- Nav tabs -->
				<ul class="nav nav-tabs" role="tablist">
				<?
				for ($iri=0; $iri < count($instructor_list); $iri++) {
					if($instructor_list[$iri][tr_cnt] > 0){
				?>
					<li class="<?=$iri == 0 ? "active" : "" ?>">
						<a href="#ir_content_<?=$instructor_list[$iri][ir_order]?>" aria-controls="ir_content_<?=$instructor_list[$iri][ir_order]?>" role="tab" data-toggle="tab">
							<?=$instructor_list[$iri][ir_category]?>
						</a>
					</li>
				<?
					}
				}
				?>
					<!-- <li class="active"><a href="#tday" aria-controls="tday" role="tab" data-toggle="tab">ENTERTAINMENTS!</a></li> -->
				</ul>
				<!-- tab panes -->
				<div class="tab-content">
				<?
				for ($iri=0; $iri < count($instructor_list); $iri++) {
					if($instructor_list[$iri][tr_cnt] > 0){
				?>
					<div role="tabpanel" class="tab-pane <?=$iri == 0 ? "active" : "" ?>" id="ir_content_<?=$instructor_list[$iri][ir_order]?>">
						<div id="ir_carousel_<?=$instructor_list[$iri][ir_order]?>" class="carousel slide" data-interval="false" data-wrap="false" data-keyboard="false">

							<div class="row">
								<div class="col-md-12 col-sm-12">
									<h3><?=$instructor_list[$iri][ir_name]?></h3>
								</div>
								<div class="col-md-2 col-sm-2">
									<img src="<?=$instructor_list[$iri][ir_picture]?>" class="img-responsive" alt="program">
								</div>
								<div class="col-md-6 col-sm-6">
									<?=$instructor_list[$iri][ir_desc]?>
								</div>
								<div class="col-md-4 col-sm-4">
									<video width="300" controls>
  									<source src="<?=$instructor_list[$iri][ir_video]?>" type="video/mp4">
  									Your browser does not support HTML video.
									</video>
								</div>
							</div>

						<?
						$page_content_cnt = 0;
						$carousel_inner_open = false;
						$carousel_item_open  = false;

						$instructor_training_cnt = 0;

						for ($tr=0; $tr < count($training_list); $tr++) {

							if($training_list[$tr][tr_ir_idx] == $instructor_list[$iri][ir_idx]){
								$instructor_training_cnt++;

								if($page_content_cnt == 0 && !$carousel_inner_open){
									$carousel_inner_open = true;
									echo '<div class="carousel-inner" role="listbox">';
								}
								if($page_content_cnt % $page_split == 0 && !$carousel_item_open){
									$carousel_item_open = true;
									echo '<div class="item '.($page_content_cnt == 0 ? 'active' : '').'">';
								}
						?>
							<!-- program speaker here -->
							<!--
							<div class="col-md-2 col-sm-2">
								<img src="<?=$training_list[$tr][ir_picture]?>" class="img-responsive" alt="program">
							</div>
						-->
							<div class="col-md-12 col-sm-12">
								<h3><?=$training_list[$tr][tr_title]?></h3>
								<h6>
								<?// if($training_list[$tr][tr_open]=="Open" || $s_m_email == "jaewangjeong7@gmail.com") { ?>
								<?if($training_list[$tr][tr_open]=="Open") { ?>
									<span><i class="fa fa-clock-o"></i> <?=$training_list[$tr][tr_date]?> </span>
									<span>* Cost: $<?=$training_list[$tr]['tr_cost']?> (&#8361;<?=number_format($training_list[$tr]['tr_cost_krw'])?>)</span>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* Duration: <?=$training_list[$tr][tr_duration]?></span>
								<? } else { ?>
									<!-- <span><i class="fa fa-clock-o"></i> <sapn style="color: red;">To be scheduled</span> </span> -->
									<span><i class="fa fa-clock-o"></i> To be scheduled </span>
									<span></span>
								<? } ?>
								</h6>
								<p><?=$training_list[$tr][tr_desc]?></p>

						<?
						$isCartItem = false;
						foreach ($_SESSION[SESSION_ID."shopping_cart"] as $product) {
							if($product[tridx] == $training_list[$tr][tr_idx]){
								$isCartItem = true;
								break;
							}
						}
						?>

								<?// if($training_list[$tr][tr_open]=="Open"|| $s_m_email == "jaewangjeong7@gmail.com") {?>
								<? if($training_list[$tr][tr_open]=="Open") {?>
								<!-- Add to Cart Button -->
								<button type="button" class="btn btn-primary addtocart" data-tridx="<?=$training_list[$tr][tr_idx]?>" data-trcost="<?=$training_list[$tr][tr_cost]?>" <?=($isCartItem ? 'disabled' : '')?>>
									<?if($isCartItem) { echo "Already added"; } else { echo "Add to Cart"; }?>
								</button>
								<?}?>

							</div>
						<?
							$page_content_cnt++;
							if( $page_content_cnt % $page_split != 0 && $page_content_cnt != $instructor_list[$iri][tr_cnt] ){
								echo '<div class="program-divider col-md-12 col-sm-12"></div>';
							}

							if($page_content_cnt % $page_split == 0 && $carousel_item_open){
								$carousel_item_open = false;
								echo '</div><!-- end item -->'; // close div
							}

						} // check instructor training

					} // end for $training_list

					if($instructor_training_cnt == 0){
						echo '<div class="carousel-inner" role="listbox">';
						echo '  <div class="item active">';
						echo '    <div class="col-md-12 col-sm-12">';
						echo $instructor_info[$instructor_list[$iri][ir_idx]];
						echo '    </div>';
						echo '  </div>';
						echo '</div>';

					}


					if($carousel_item_open){
						$carousel_item_open = false;
						echo '</div><!-- end item last -->'; // close div
					}

					if($carousel_inner_open){
						$carousel_inner_open = false;
						echo '</div><!-- end carousel-inner last -->'; // carousel-inner
					}

					if($page_content_cnt > $page_split){
					?>
						<div class="program-divider col-md-12 col-sm-12" style="margin-bottom: 10px;"></div>

						<!-- Indicators -->
						<div class="col-md-10 col-sm-10" style="text-align:center;">
							<nav aria-label="Page navigation carousel-indicators">
								<ul class="pagination">
									<li data-target="#ir_carousel_<?=$instructor_list[$iri][ir_order]?>" data-slide="prev" class="page-item">
										<a class="page-link" aria-label="Previous">
											<span aria-hidden="true" style="padding-right:0px;">Prev</span>
										</a>
									</li>
									<?
									$total_page  = $instructor_list[$iri][tr_cnt] / $page_split;
									for ($pi=0; $pi < $total_page; $pi++) {
									?>
									<li data-target="#ir_carousel_<?=$instructor_list[$iri][ir_order]?>" data-slide-to="<?=$pi?>" class="page-item"><a class="page-link"><?=($pi+1)?></a></li>
									<?
									}
									?>
									<li data-target="#ir_carousel_<?=$instructor_list[$iri][ir_order]?>" data-slide="next" class="page-item">
										<a class="page-link" aria-label="Next">
											<span aria-hidden="true" style="padding-right:0px;">Next</span>
										</a>
									</li>
								</ul>
							</nav>
						</div>
					<? } ?>

					</div> <!-- end carousel -->

				</div> <!-- tabpanel  -->
				<?
					}
				}
				?>

		</div> <!-- end row -->
	</div> <!-- container -->
</section>



<!------------------------->
<!-- Shopping Cart Modal -->
<!------------------------->
<div class="modal fade" id="modal-cart-info" style="margin-top:150px;">
	<div class="modal-dialog" id="modal-cart-info-dialog">
		<div class="modal-content">
			<div class="modal-header" style="background-color: #0480be; color: white;">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title" id="modal-cart-info-title">
					Add to Cart Information
				</h4>
			</div>
			<div class="modal-body" id="modal-cart-info-body" style="text-align: center;">
				<h3>Registration for all sessions <br/>will be available on August 17th.</h3>
			</div>
		</div>
		<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script type="text/javascript">

$(document).ready(function(){

	//-------------------------------------------
	// Add to Cart
	//-------------------------------------------
	$(document).on('click', 'button.showCart', function(e){
		editcall("","","SHOPPING CART!");
	});

	$(document).on('click', 'button.addtocart', function(e){
		var tridx = $(this).data('tridx');
		var trcost = $(this).data('trcost');
		editcall(tridx,trcost,"SHOPPING CART!");
	});

    $(document).on('click', 'button.free-seminar-btn', function(e){
        if($(this).prop('disabled')){
             //alert("You've already registered.");
        }else{
            $.ajax({
                method : 'POST',
                url : './data_process_work.php',
                dataType : 'json',
                data: { 'paymentmode' : 'freeSeminar' },
                success: function(data){
                    if(data.completed == "Y"){
                        alert('You`ve successfully completed registration for the free seminar.');
                        location.reload();
                    }else{
                        if(data.code == "notLogin"){
                            alert("Did not login. You can register after logging in.");
                            location.reload();
                        }else if(data.code == "already"){
                            alert("You've already registered.");
                        }
                    }
                },
                beforeSend: function(jqXHR, settings ){
                    showLoading();
                },
                complete: function(jqXHR, status){
                    hideLoading();
                },
                error: function(data){
                }
            });
        }
	});

	//-------------------------------------------
	// Call Modal for Free Seminar Booking
	//-------------------------------------------
	$(document).on('click', 'button.private-seminar-btn', function(e){
		var booktridx = $(this).data('booktridx');
		var booktdidx = $(this).data('booktdidx');
		var midx = $(this).data('midx');
		registercall(booktridx,booktdidx,midx,"REGISTER!","new");
	});

	$(document).on('click', 'a.private-seminar-edit-btn', function(e){
		var booktridx = $(this).data('booktridx');
		var booktdidx = $(this).data('booktdidx');
		var midx = $(this).data('midx');
		registercall(booktridx,booktdidx,midx,"Booking Information","edit");
	});

});

//-------------------------------------------
// Add to Cart Call
//-------------------------------------------
function editcall(tridx,trcost,modaltitle) {

	$('#custom-modal').addClass("modal-lg");

	var showEditModal = true;

	if(showEditModal){
		$.ajax({
			method : 'POST',
			url : './cart_new.php',
			//dataType : 'html',
			data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
			success: function(data){
				$('#modaltitle').text(modaltitle);
				$('#modal-data-edit-body').html(data);
				$('#modal-data-edit').modal();

				$.each($('#modal-data-edit select'), function(i,v){
					$(v).select2();
				});
				// var add_cart_tr_idx = $('#modal-data-edit-body').find('input[name=add_cart_tr_idx]').val();
				// if(add_cart_tr_idx != ''){
				// 	$('button.addtocart[data-tridx=2]').prop('disabled', true);
				// }
			},
			beforeSend: function(jqXHR, settings ){
				showLoading();
			},
			complete: function(jqXHR, status){
				hideLoading();
			},
			error: function(data){
			}
		});
	}
}//editcall

function registercall(booktridx,booktdidx,midx,modaltitle,bookingmode) {

	var showEditModal = true;

	if(showEditModal){
		$.ajax({
			method : 'POST',
			url : './training_free_booking.php',
			//dataType : 'html',
			data: { 'booktridx' : booktridx, 'booktdidx' : booktdidx, 'midx' : midx, 'bookingmode' : bookingmode },
			success: function(data){
				if(data == 'Not Login'){
					alert("Did not login. You can registe after logging in.");
					// location.reload();
					logincall("","","MEMBER LOGIN");
				}else if(data == 'Already Registed'){
					alert('You already booked with the other date.');
				}else if(data == 'Already Booked'){
					alert('This date has already been booked.');
					location.reload();
				}else{
					$('#modaltitle').text(modaltitle);
					$('#modal-data-edit-body').html(data);
					$('#modal-data-edit').modal();
				}
			},
			beforeSend: function(jqXHR, settings ){
				showLoading();
			},
			complete: function(jqXHR, status){
				hideLoading();
			},
			error: function(data){
			}
		});
	}
}

function rudTraingingFreeBooking(bookingmode){

	var booktridx        = $.trim($('#training-free-booking-form input[name=booktridx]').val());
	var booktdidx        = $.trim($('#training-free-booking-form input[name=booktdidx]').val());
	var tfbcompany       = $.trim($('#training-free-booking-form input[name=tfbcompany]').val());
	var discusstiontopic = $.trim($('#training-free-booking-form textarea[name=discusstiontopic]').val());
	var _td = $('#SeminarRegisterTable td[data-booktridx="'+booktridx+'"][data-booktdidx="'+booktdidx+'"]');

	if(tfbcompany == ""){
		alert('Please input Company.');
		return false;
	}

	if(discusstiontopic == ""){
		alert('Please input Discussion Topic.');
		return false;
	}

	var _msg = "";
	if(bookingmode == "delete"){
		_msg = " Do you want to cancel your booking? ";
	}

	if(bookingmode == "new" || bookingmode == "edit" || confirm(_msg)){
		$.ajax({
			method : 'POST',
			url : './data_process.php',
			dataType : 'json',
			data: {
				'bookingmode' : bookingmode,
				'booktridx' : booktridx,
				'booktdidx' : booktdidx,
				'tfbcompany' : tfbcompany,
				'discusstiontopic' : discusstiontopic
			},
			success: function(res){
				if(res.isOK == "Y"){
					if(bookingmode == "new" || bookingmode == "edit"){
						var _td_html = '<small>Booked by</small><br/><b>';
						_td_html+= '<a href="javascript:void(0);" class="private-seminar-edit-btn" data-booktridx="'+booktridx+'" data-booktdidx="'+booktdidx+'">'+tfbcompany+'</a></b>';
						_td.html(_td_html);
					}
					if(bookingmode == "delete"){
						_td.html('<button class="btn btn-sm btn-primary private-seminar-btn" data-booktridx="'+booktridx+'" data-booktdidx="'+booktdidx+'">Register</button>');
					}
					$('#modal-data-edit').modal('hide');
				}else{
					alert(res.message)
				}
			},
			beforeSend: function(jqXHR, settings ){
				showLoading();
			},
			complete: function(jqXHR, status){
				hideLoading();
			},
			error: function(data){
			}
		});
	}
}
</script>
