<?
// ----------------------------------
// Email Sander information
// ----------------------------------
$fromName = 'KIOSC';
$from = 'info@kiosc.org';
// ----------------------------------


// ----------------------------------
// Payment Data
// ----------------------------------
function getPaymentDataByPMID($_pm_id, $conn){

	$payment = array();
	$SQL = " SELECT m.m_id, m.m_name, m.m_email, m.m_company, p.* FROM payment p JOIN member m ON m.m_idx = p.m_idx WHERE p.pm_id = '$_pm_id' LIMIT 1 ";
	$Result = mysqli_query($conn, $SQL);

	while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
		$payment = $ResultsRow;
	}

	$training_list = array();
	$SQL = " SELECT * ";
	$SQL.= " FROM payment_training ";
	$SQL.= " WHERE pm_idx = '".$payment[pm_idx]."' ";
	$SQL.= " ORDER BY tr_idx ASC ";
	$Result = mysqli_query($conn, $SQL);

	while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
		array_push($training_list, $ResultsRow);
	}

	$payment[training] = $training_list;

	return $payment;
}
// ----------------------------------
// Payment Data
// ----------------------------------


// ----------------------------------
// Payemet Completed Email Send
// ----------------------------------
function paymentEmail($_mname, $_memail, $_mcompany, $_payment_detail){
	global $fromName;
	global $from;

	$message = getPaymentEmailContent("payment", $_mname, $_memail, $_mcompany, $_payment_detail);

	$subject = 'Thank you for purchasing from KIOSC Training Center!';

	$headers = "MIME-Version: 1.0" . "\r\n";
	$headers.= "Content-type:text/html;charset=UTF-8" . "\r\n";
	$headers.= "From: $fromName"." <".$from.">"."\r\n";

	$mail = mail($_memail, $subject, $message, $headers);

	return $mail;
}
// ----------------------------------
// Payemet Completed Email Send
// ----------------------------------


// ----------------------------------
// Payemet Information Email Send
// ----------------------------------
function infoPaymentEmail($_mname, $_memail, $_mcompany, $_payment_detail){
	global $fromName;
	global $from;

	$message = getPaymentEmailContent("info", $_mname, $_memail, $_mcompany, $_payment_detail);

	$to = "info@kiosc.org";
	$cc = "jaekim@kcrnresearch.com, jaydenseo@kcrnresearch.com, josephhong@kcrnresearch.com, jaewangjeong.developer@gmail.com";

	$subject = "KIOSC New Traingin Payment.";

	$headers = "MIME-Version: 1.0" . "\r\n";
	$headers.= "Content-type:text/html;charset=UTF-8" . "\r\n";
	$headers.= "From: $fromName"." <".$from.">"."\r\n";
	$headers.= "Cc: ". $cc . "\r\n";

	$mail = mail($to, $subject, $message, $headers);

	return $mail;
}
// ----------------------------------
// Payemet Information Email Send
// ----------------------------------


// ----------------------------------
// Payemet Receipt Email Send
// ----------------------------------
function paymentEmailWithReceipt($file, $_mname, $_memail, $_mcompany, $_payment_detail){
	global $fromName;
	global $from;

	// $_pm_id, $_mname, $_memail, $_mcompany, $_pm_discount, $_pm_amount

	$htmlContent = getPaymentEmailContent("receipt", $_mname, $_memail, $_mcompany, $_payment_detail);

	// Email subject
	$subject = 'Thank you for purchasing from KIOSC Training Center!';

	// Header for sender info
	$headers.= "From: $fromName"." <".$from.">";

	// Boundary
	$semi_rand = md5(time());
	$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

	// Headers for attachment
	$headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";

	// Multipart boundary
	$message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" . "Content-Transfer-Encoding: 7bit\n\n" . $htmlContent . "\n\n";

	// Preparing attachment
	if(!empty($file) > 0){
	    if(is_file($file)){
	        $message .= "--{$mime_boundary}\n";
	        $fp =    @fopen($file,"rb");
	        $data =  @fread($fp,filesize($file));

	        @fclose($fp);
	        $data = chunk_split(base64_encode($data));
	        $message .= "Content-Type: application/octet-stream; name=\"".basename($file)."\"\n" .
	        "Content-Description: ".basename($file)."\n" .
	        "Content-Disposition: attachment;\n" . " filename=\"".basename($file)."\"; size=".filesize($file).";\n" .
	        "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
	    }
	}
	$message .= "--{$mime_boundary}--";
	$returnpath = "-f" . $from;

	// Send email
	$mail = @mail($_memail, $subject, $message, $headers, $returnpath);

	return $mail;
}
// ----------------------------------
// Payemet Receipt Email Send
// ----------------------------------



// ----------------------------------
// Payemet Email Html Content Create
// ----------------------------------
function getPaymentEmailContent($_target, $_mname, $_memail, $_mcompany, $_payment_detail){

$_email_content_top = <<<'EOT'
<html style="display: block;font-family: Arial, Helvetica Neue, Helvetica, sans-serif;">
<body style="background-color: rgb(242, 242, 242);">
	<div style="width:640px;padding: 20px;margin-left:40px;margin-top:40px;background-color: rgb(255,255,255);">
		<img width="181" src="https://kiosc.org/business_Jae/images/confirm_email_img0.png" style="display: block; padding: 15px 0px; margin: 0px auto;">
			<p style="text-align: center;font-size: 25px;color: #737373; line-height: 200%;">
EOT;

$_email_content_end = <<<'EOT'
		</p>
		<br/>
		<p style="text-align: center;font-size: 11px;color: #737373;mso-line-height-rule: exactly; padding-bottom:20px;">
			If you have any questions about your order, please contact us at <a href="mailto:info@kiosc.org" target="_blank" data-redactor-style-cache="color: rgb(252, 136, 5);" style="color: rgb(252, 136, 5);">info@kiosc.org﻿</a>
		</p>
	</div>
</body>
</html>
EOT;

$_email_content_body = "";
if($_target == "info"){
	$_email_content_body  = '<strong>New Training Payment</strong>';
	$_email_content_body .= '</p>';
	$_email_content_body .= '<p style="text-align: center;font-size: 14px;color: #737373; line-height: 150%; padding: 0px 10px;">';
	$_email_content_body .= '<strong>Name : '.$_mname.'</strong><br/>';
	$_email_content_body .= '<strong>Eamil : '.$_memail.'</strong><br/>';
	$_email_content_body .= '<strong>Company : '.$_mcompany.'</strong>';
	$_email_content_body .= '<br/><br/>';
	$_email_content_body .= $_payment_detail;

}else{

	$_email_content_body  = '<strong>Thank you for your order from the</strong><br/><strong>KIOSC Training Center!</strong>';
	$_email_content_body .= '</p>';
	$_email_content_body .= '<p style="text-align: center;font-size: 14px;color: #737373; line-height: 150%; padding: 0px 10px;">';

	$_email_content_body.= "<strong>Dear $_mname</strong><br><br>";
	$_email_content_body.= "<strong>Thank you for your order from the</strong><br/>";
	$_email_content_body.= "<strong>KIOSC Training Center!</strong><br/>";

	$_email_content_body.= '   Thank you for your registration.<br> ';
	$_email_content_body.= '   Your payment has been successfully sent to the KIOSC Training Center.<br/><br/> ';
	if($_target == "receipt"){
		$_email_content_body.= '   Please print the attached receipt for your records.<br> ';
		$_email_content_body.= '   We will send you the course link within 2 or 3 days before the course is scheduled.<br><br> ';
	}
	$_email_content_body.= '   If you have any questions, please email us.<br><br> ';
	$_email_content_body.= '   Best regards,<br> ';
	$_email_content_body.= '   KIOSC Training Center.<br><br> ';

	$_email_content_body .= $_payment_detail;

	$_email_content_body .= "<br>﻿<br>﻿<br>﻿We look forward to seeing you in session!";
}

return $_email_content_top.$_email_content_body.$_email_content_end;

/*
	<html style="display: block;font-family: Arial, Helvetica Neue, Helvetica, sans-serif;">
	<body style="background-color: rgb(242, 242, 242);">
		<div style="width:640px;padding: 20px;margin-left:40px;margin-top:40px;background-color: rgb(255,255,255);">
			<img width="181" src="https://kiosc.org/business_Jae/images/confirm_email_img0.png" style="display: block; padding: 15px 0px; margin: 0px auto;">
			<p style="text-align: center;font-size: 25px;color: #737373; line-height: 200%;">
				<strong>Thank you for your order from the</strong><br/>
				<strong>KIOSC Training Center!</strong>
			</p>
			<p style="text-align: center;font-size: 14px;color: #737373; line-height: 150%; padding: 0px 10px;">
				<strong>Dear ABC</strong><br><br>
				Thank you for your registration.<br>
				Your payment has been successfully sent to the KIOSC Training Center.<br/>
				We will send you the receipt and the course link within 2 or 3 days before the course is scheduled..<br><br>
				If you have any questions, please email us.<br><br>
				Best regards,<br>
				KIOSC Training Center.<br><br>
				﻿<br>Aaaaaaaaaaaaaaaaaaa – Price $75.00
				﻿<br>Bbbbbbbbbbbbbbbbbbb – Price $75.00
				﻿<br>Discount amount $﻿﻿0.00
				﻿<br>﻿Total Amount Charged $0.00
				<br>﻿<br>﻿<br>﻿We look forward to seeing you in session!
			</p>
			<p style="text-align: center;font-size: 11px;color: #737373;mso-line-height-rule: exactly; padding-bottom:20px;">
				If you have any questions about your order, please contact us at <a href="mailto:info@kiosc.org" target="_blank" data-redactor-style-cache="color: rgb(252, 136, 5);" style="color: rgb(252, 136, 5);">info@kiosc.org﻿</a>
			</p>
		</div>
	</body>
	</html>
*/


}
// ----------------------------------
// Payemet Email Html Content Create
// ----------------------------------



// ----------------------------------
// Create Receipt PDF File
// ----------------------------------
function createReceiptPdf($_pm_id, $conn){

	$_pdf_name = "KIOSC_RECEIPT_".$_pm_id;
	$output_file = dirname(__FILE__)."/receipt/".$_pdf_name.".pdf";



	if(!file_exists($output_file)){

		$payment = getPaymentDataByPMID($_pm_id, $conn);

		$root_path  = $_SERVER['DOCUMENT_ROOT'];
		$root_path  = strpos($root_path, "/business_Jae") === false ? $root_path : str_replace("/business_Jae", "", $root_path);
		$tcpdf_path = $root_path."/libs/TCPDF-6.2.26/tcpdf.php";
		$tcpdf_include_path = $root_path."/libs/TCPDF-6.2.26/tcpdf_include.php";

		include_once($tcpdf_path);

		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('KIOSC');
		$pdf->SetTitle($_pdf_name);
		$pdf->SetSubject('');
		$pdf->SetKeywords('');

		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// set some language-dependent strings (optional)
		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		    require_once(dirname(__FILE__).'/lang/eng.php');
		    $pdf->setLanguageArray($l);
		}

		// ---------------------------------------------------------

		// add a page
		$pdf->AddPage();

		$style_tf_line = array('width' => 6, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(67, 137, 178));

		// Page size x:210 - y:297

		// Line x-left-opsition, y-left-opsition, x-right-position, y-right-position, style
		$pdf->Line(0, 3, 210, 3, $style_tf_line);

		$pdf->SetFont('aefurat', '', 26);
		$pdf->SetTextColor(127, 127, 127);
		$pdf->Text(15, 25, 'RECEIPT');

		// Image example with resizing
		$pdf->Image('./images/logo_general.png', 145, 25, 50, 16, '', '', '', false, 100, '', false, false, 1, false, false, false);

		$info_width = array(145, 35);

		$pdf->Ln(30);

		$pdf->SetFillColor(243, 243, 243);
		$pdf->SetDrawColor(191, 191, 191);
		$pdf->SetLineWidth(0.2);
		$pdf->SetFont('nanumbarungothicyethangul', '', 10);

		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell($info_width[1],  6, "PAYMENT DATE", "B", 0, 'C', false);


		$_payment_date = $payment[pm_u_data];
		$_payment_date = str_replace('T', ' ', $_payment_date);
		$_payment_date = str_replace('Z', ' ', $_payment_date);
		$pdf->Ln();
		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(0);
		$pdf->SetFont('nanumbarungothicyethangul');
		$pdf->Cell($info_width[1], 6, $_payment_date, 0, 0, 'C', false);


		$pdf->Ln();
		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell($info_width[1], 6, "RECEIPT NO.", "B", 0, 'C', false);


		$pdf->Ln();
		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(0);
		$pdf->SetFont('nanumbarungothicyethangul');
		$pdf->Cell($info_width[1], 6, $_pm_id, 0, 0, 'C', false);

		// -------------------------------------------------------
		// From / BILL TO
		// -------------------------------------------------------
		$pdf->Ln(15);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell(85, 7, "FROM", "B", 0, 'L', false);
		$pdf->Cell(10, 7, "", 0, 0, 'L', false);
		$pdf->Cell(85, 7, "BILL TO", "B", 0, 'L', false);

		$pdf->SetTextColor(0);


		$pdf->Ln();
		$pdf->SetFont('nanumbarungothicyethangul', '', 10);
		$pdf->Cell(85, 6, "KIOSC Training Center", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		$pdf->Cell(85, 6, $payment[m_name], 0, 0, 'L', false);

		$pdf->Ln();
		$pdf->Cell(85, 6, "12311 Middlebrook Rd", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		if($payment[m_company] != ""){
			$pdf->Cell(85, 6, $payment[m_company], 0, 0, 'L', false);
		}else{
			$pdf->Cell(85, 6, $payment[m_email], 0, 0, 'L', false);
		}

		$pdf->Ln();
		$pdf->Cell(85, 6, "Suite 300", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		if($payment[m_company] != ""){
			$pdf->Cell(85, 6, $payment[m_email], 0, 0, 'L', false);
		}else{
			$pdf->Cell(85, 6, "", 0, 0, 'L', false);
		}

		$pdf->Ln();
		$pdf->Cell(85, 6, "Germantown, MD 20874", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		$pdf->Cell(85, 6, "", 0, 0, 'L', false);

		$pdf->Ln();
		$pdf->Cell(85, 6, "info@kiosc.org", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		$pdf->Cell(85, 6, "", 0, 0, 'L', false);

		// $pdf->Ln(15);
		// $pdf->Cell($info_width[0], 6, "", "B", 0, 'L', false);
		// $pdf->Cell($info_width[1], 6, "", "B", 0, 'C', false);

		// -------------------------------------------------------
		// Training Information Table
		// -------------------------------------------------------
		$pdf->Ln(20);
		$table_width = array(95, 15, 35, 35);
		$_header = array('DESCRIPTION', 'QTY', 'UNIT PRICE', 'TOTAL');

		$pdf->SetFillColor(67, 137, 178);
		$pdf->SetDrawColor(67, 137, 178);
		$pdf->SetTextColor(255);
		$pdf->SetLineWidth(0.1);
		$pdf->SetFont('helvetica', 'B');
		$pdf->Cell($table_width[0], 7, $_header[0], 1, 0, 'C', true);
		$pdf->Cell($table_width[1], 7, $_header[1], 1, 0, 'C', true);
		$pdf->Cell($table_width[2], 7, $_header[2], 1, 0, 'C', true);
		$pdf->Cell($table_width[3], 7, $_header[3], 1, 0, 'C', true);

		$pdf->Ln();
		// Color and font restoration
		$pdf->SetFillColor(243, 243, 243);
		$pdf->SetDrawColor(191, 191, 191);
		$pdf->SetTextColor(0);
		$pdf->SetLineWidth(0.1);
		$pdf->SetFont('nanumbarungothicyethangul');
		// Data
		$fill = false;
		foreach($payment[training] as $training) {
			$_row = ceil(strlen($training[tr_title]) / 55);
			$_cellHeight = 6 * $_row;
			// $pdf->Cell($table_width[0], 6, $training[tr_title], 1, 0, 'L', $fill);
			// MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)
			// $pdf->MultiCell($table_width[0], $_cellHeight, $training[tr_title], 1, 'L', $fill, 0, '', '');
			$pdf->MultiCell($table_width[0], $_cellHeight, $training[tr_title], 1, 'L', $fill, 0, '', '', true, 0, false, true, $_cellHeight, 'M');
			$pdf->Cell($table_width[1], $_cellHeight, "1", 1, 0, 'C', $fill);
			if($payment["pm_currency_code"] == "KRW"){
				$pdf->Cell($table_width[2], $_cellHeight, number_format($training[tr_cost]), 1, 0, 'R', $fill);
				$pdf->Cell($table_width[3], $_cellHeight, number_format($training[tr_cost]), 1, 0, 'R', $fill);
			}else{
				$pdf->Cell($table_width[2], $_cellHeight, "$".sprintf('%0.2f', number_format($training[tr_cost])), 1, 0, 'R', $fill);
				$pdf->Cell($table_width[3], $_cellHeight, "$".sprintf('%0.2f', number_format($training[tr_cost])), 1, 0, 'R', $fill);
			}
			$pdf->Ln();
			$fill=!$fill;
		}

		$pdf->SetLineWidth(0.1);

		$pdf->Ln(10);
		$pdf->SetTextColor(0);
		$pdf->Cell($table_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(0);
		$pdf->Cell($table_width[1], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell($table_width[2], 6, "SUBTOTAL", 0, 0, 'R', false);
		$pdf->SetTextColor(0);
		$pdf->SetFont('nanumbarungothicyethangul');
		if($payment["pm_currency_code"] == "KRW"){
			$pdf->Cell($table_width[3], 6, number_format($payment[pm_pre_amount]), "B", 0, 'R', false);
		}else{
			$pdf->Cell($table_width[3], 6, "$".sprintf('%0.2f', number_format($payment[pm_pre_amount])), "B", 0, 'R', false);
		}

		if($payment[pm_discount] > 0){
			$pdf->Ln(8);
			$pdf->SetTextColor(0);
			$pdf->Cell($table_width[0], 6, "", 0, 0, 'L', false);
			$pdf->SetTextColor(0);
			$pdf->Cell($table_width[1], 6, "", 0, 0, 'L', false);
			$pdf->SetTextColor(31, 56, 100);
			$pdf->SetFont('helvetica');
			$pdf->Cell($table_width[2], 6, "DISCOUNT", 0, 0, 'R', false);
			$pdf->SetTextColor(0);
			$pdf->SetFont('nanumbarungothicyethangul');
			if($payment["pm_currency_code"] == "KRW"){
				$pdf->Cell($table_width[3], 6, number_format($payment[pm_discount]), "B", 0, 'R', false);
			}else{
				$pdf->Cell($table_width[3], 6, "$".sprintf('%0.2f', number_format($payment[pm_discount])), "B", 0, 'R', false);
			}
		}

		$pdf->Ln(8);
		$pdf->SetDrawColor(0, 0, 0);
		$pdf->Cell($table_width[0], 6, "", 0, 0, 'R', false);
		$pdf->Cell($table_width[1], 6, "", 0, 0, 'R', false);
		$pdf->Cell($table_width[2], 6, "", "B", 0, 'R', false);
		$pdf->Cell($table_width[3], 6, "", "B", 0, 'R', false);

		$pdf->Ln(10);
		$pdf->Cell($table_width[0], 6, "", 0, 0, 'R', false);
		$pdf->Cell($table_width[1], 6, "", 0, 0, 'R', false);
		$pdf->SetFont('helvetica', 'B', 12);
		$pdf->Cell($table_width[2], 6, "Paid", 0, 0, 'R', false);
		$pdf->SetFont('nanumbarungothicyethangul', 'B', 12);
		if($payment["pm_currency_code"] == "KRW"){
			$pdf->Cell($table_width[3], 6, number_format($payment[pm_amount]), "B", 0, 'R', false);
		}else{
			$pdf->Cell($table_width[3], 6, "$".sprintf('%0.2f', number_format($payment[pm_amount])), "B", 0, 'R', false);
		}

		$pdf->Ln(20);
		$pdf->SetFont('helvetica', '', 10);
		$pdf->SetTextColor(0);
		$pdf->Cell(180, 6, "Thank you for your business.", 0, 0, 'R', false);


		// if(!file_exists($output_file)){
			$pdf->Output($output_file, 'F');
		// }
	}
	// $pdf->Output($output_file, 'I');

	return $output_file;
}
// ----------------------------------
// Create Receipt PDF File
// ----------------------------------



// ----------------------------------
// Payment OS And Browser Information
// ----------------------------------
function getUserAgentInfo(){
	$userAgentInfo = array();
	$userAgent = $_SERVER["HTTP_USER_AGENT"];
	$userAgentInfo[agent] = $userAgent;
	// Find OS
	if (preg_match('/linux/i', $userAgent)){
		$userAgentInfo[OS] = 'Linux';
	} elseif(preg_match('/macintosh|mac os x/i', $userAgent)){
		$userAgentInfo[OS] = 'Mac';
	} elseif (preg_match('/windows|win32/i', $userAgent)){
		$userAgentInfo[OS] = 'Windows';
	} else {
		$userAgentInfo[OS] = 'Other';
	}

	// Find Browser
	if(preg_match('/MSIE/i',$userAgent) && !preg_match('/Opera/i',$u_agent)){

		if ( preg_match("/MSIE 6.0[0-9]*/", $userAgent) ) {
			$userAgentInfo[Browser] = "Internet Explorer 6";
		} elseif ( preg_match("/MSIE 7.0*/", $userAgent) ) {
			$userAgentInfo[Browser] = "Internet Explorer 7";
		} elseif ( preg_match("/MSIE 8.0*/", $userAgent) ) {
			$userAgentInfo[Browser] = "Internet Explorer 8";
		} elseif ( preg_match("/MSIE 9.0*/", $userAgent) ) {
			$userAgentInfo[Browser] = "Internet Explorer 9";
		} elseif ( preg_match("/MSIE 10.0*/", $userAgent) ) {
			$userAgentInfo[Browser] = "Internet Explorer 10";
		} else{
			$userAgentInfo[Browser] = "Internet Explorer ETC";
		}
	} elseif ( preg_match("/Trident*/", $userAgent) && preg_match("/rv:11.0*/", $userAgent) && preg_match("/Gecko*/", $userAgent) ) {
		$userAgentInfo[Browser] = "Internet Explorer 11";
	} else if(preg_match('/Edge/i',$userAgent)){
		$userAgentInfo[Browser] = 'Internet Explorer Edge';
	} else if(preg_match('/Firefox/i',$userAgent)){
		$userAgentInfo[Browser] = 'Mozilla Firefox';
	} else if (preg_match('/Chrome/i',$userAgent)){
		$userAgentInfo[Browser] = 'Google Chrome';
	} else if(preg_match('/Safari/i',$userAgent)){
		$userAgentInfo[Browser] = 'Apple Safari';
	} elseif(preg_match('/Opera/i',$userAgent)){
		$userAgentInfo[Browser] = 'Opera';
	} elseif(preg_match('/Netscape/i',$userAgent)){
		$userAgentInfo[Browser] = 'Netscape';
	} else{
		$userAgentInfo[Browser] = "Other";
	}
	// Sample Data
	// Array ( [agent] => Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36 [OS] => Mac [Browser] => Google Chrome )
	return $userAgentInfo;
}
// ----------------------------------
// Payment OS And Browser Information
// ----------------------------------

?>
