<?
// ---------------------------------------------------
// Config for PayPal specific values
// ---------------------------------------------------

// PayPal Environment
// define("PAYPAL_ENVIRONMENT", "sandbox");
define("PAYPAL_ENVIRONMENT", "production");

// PayPal REST API endpoints
define("PAYPAL_ENDPOINTS", array(
	"sandbox" => "https://api.sandbox.paypal.com",
	"production" => "https://api.paypal.com"
));

// PayPal REST App credentials
define("PAYPAL_CREDENTIALS", array(
	"sandbox" => [
		"client_id" => "AQgLOJSmPx3YfcMoK-WRkXxTDrM-QQPA3mCObeHpi3IJgYiuVuTr-6DGRru4hmZ0xMMD8jmj_988_cPU",
		"client_secret" => "EKa89kwti9upDLMt9DZOm8IN4e2GqdZU_ieeyAprsnBWqvVAW2WbmYcrYX5GYDrAIJpUkShEamkQtH_K"
	],
	"production" => [
		"client_id" => "Aao-oOjtT3pIgtXmex9lCu0ImL73aTZOmnXzZvigr0Muq9-q8SkxiEG_JACm15Z3iwej7WLc7gx8U7Ej",
		"client_secret" => "EJ6uOug_TDsnUh_kxGujAy_rz8pQrTEYGG13p78HBiD8MbpMasEgSiHxnihq0Cgt2NuKpnGEccOUne-E"
	]
));

?>

<!-- Javascript Import -->
<script src="https://www.paypal.com/sdk/js?client-id=<?=PAYPAL_CREDENTIALS[PAYPAL_ENVIRONMENT][client_id]?>&disable-funding=credit,venmo"></script>


<!-- PayPal In-Context Checkout script -->
<script type="text/javascript">
$(document).ready(function(){
});

function checkValidation(){
	var cartIdx = "";
	$.each($('.payment-cart .payment-cart-item'), function(i,v){
		var _idx = $(v).data('idx');
		cartIdx += (cartIdx == "" ? _idx : ","+ _idx);
	});

	if(cartIdx == ""){
		alert('No Cart Item');
		return false;
	}
	return true;
}



paypal.Buttons({
	// Set your environment
	env: '<?= PAYPAL_ENVIRONMENT ?>',

	// Set style of button
	style: {
		layout:  'horizontal',
		color:   'gold',
		shape:   'pill',
		label:   'checkout',
		tagline: false,
		height: 40
	},

	onClick: function(data, actions){
		// validation check
		if(checkValidation()){
			showLoading();
			return true;
		}else{
			return false;
		}
	}
	, createOrder: function(data, actions) {

		// This function sets up the details of the transaction, including the amount and line item details.
		return actions.order.create({
			intent: "CAPTURE",
			application_context: { shipping_preference: "NO_SHIPPING" },
			purchase_units: [{
				amount: {
					value: $('#total_price').val()
				}
			}]
		});

	}
	, onApprove: function(data, actions) {
		// This function captures the funds from the transaction.
		return actions.order.capture().then(function(details) {
			details['paymentmode'] = "payment";
			details['couponCode']  = $.trim($("#couponCode").val());

			$.ajax({
				url : 'data_process.php',
				method : 'POST',
				async: false,
				data: details,
				success: function(data){
					alert('Thanks for your order.\nWe will send you a confirmation email soon.');
					location.href = "checkout_completed_new.php";
				}
				,beforeSend: function(jqXHR, settings ){
				}
				,error: function(jqXHR, status, error){
					alert('Checkout Error,\nPlease contact us.');
				}
				,complete: function(jqXHR, status){
				}
			});
		});
	}
	, onCancel: function (data) {
		hideLoading();
		// Show a cancel page, or return to cart
	}
	, onError: function (err) {
		hideLoading();
		// Show an error page here, when an error occurs
	}

}).render('#paypal-button-container');

</script>
