<?php
include_once "inc/common.php";
if ($s_m_name == "") {
	echo("<script>window.alert('Checkout can be done after login.');</script>");
	echo("<meta http-equiv='Refresh' content='0; URL=index_new.php'>");
	exit;
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title>KIOSC - Course Payment</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<!-- MATERIAL DESIGN ICONIC FONT -->
	<link rel="stylesheet" href="fonts/material-design-iconic-font/css/material-design-iconic-font.min.css">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- STYLE CSS -->
	<link rel="stylesheet" href="css/style_checkout.css?v=2020051401">

	<script src="js/jquery.js"></script>
	<script src="js/checkout.js"></script>

</head>
<body>

	<div class="wrapper" style="background-image: url('images/bg-registration-form-2.jpg');">
		<div class="inner">

			<form class="member-form" id="member-form" action="#" method="post">

				<h3>Course Payment</h3>
				<div class="form-group">
					<div class="form-wrapper">
						<label for="">Full Name<sup></sup></label>
						<input type="text" class="form-control" id="mname" name="mname" value="<?=$s_m_name?>" readonly>
						<div id="nameerror" style="color: #9e251c;"></div>
					</div>
					<div class="form-wrapper">
  						<label for="">Email<sup>*</sup></label>
  						<input type="text" class="form-control" id="memail" name="memail" value="<?=$s_m_email?>" readonly>
  						<div id="emailerror" style="color: #9e251c;"></div>
  					</div>
				</div>
				<!--
				<div class="form-wrapper">
					<label for="">Company Name</label>
					<input type="text" class="form-control" id="mcompany" name="mcompany" value="<?=$s_m_company?>" readonly>
					<div id="typeerror" style="color: #9e251c;"></div>
				</div>
			-->
				<br>
				<br><br>

			</form>

			<div class="cartinfo">
				<br><br>
				<b>Checkout Course Information</b>
				<table class="table table-striped payment-cart" style="font-size:14px;width:100%;border-collapse: collapse;">
					<tr style="border-bottom: 1px solid #dddddd;">
						<td>Description</td>
						<td>Cost</td>
					</tr>
					<?
					$cart_item_idx = 0;
					$total_price = 0;
					foreach ($_SESSION[SESSION_ID."shopping_cart"] as $product) {
						$total_price = $total_price + $product["trcost"];
					?>
					<tr class="payment-cart-item" data-idx="<?=$product[tridx]?>" data-title="<?=$product["trtitle"]?>" data-cost="<?=$product["trcost"]?>" style="border-bottom: 1px solid #dddddd;">
						<td><?=$product["trtitle"]?></td>
						<td class="cost_text">$<?=$product["trcost"]?></td>
					</tr>
					<?
					}
					?>
					<tr style="font-size:16px;">
						<td>Total Cost</td>
						<td class="total_cost_text">$<?=$total_price?></td>
					</tr>
				</table>
				<input type="hidden" id="total_price" value="<?=$total_price?>"/>
			</div>

			<div class="form-group" style="width: 100%;padding-left: 45px;padding-right: 45px;margin-bottom:25px;">
				<div class="input-group">
					<span class="input-group-addon">Coupon</span>
					<input type="text" class="form-control" id="couponCode" placeholder="Coupon Code" aria-describedby="couponCode" value="">
					<span class="input-group-btn">
						<button class="btn btn-primary btn-coupon" type="button" onclick="checkCouponCode(this)">Apply</button>
					</span>
				</div>
			</div>
			<br><br>

			<!-- Checkout Options -->
			<div class="form-group">
				<div class="col-md-6 col=sm-12" style="padding-left:50px;">
					<button class="btn btn-danger" type="button" onclick="history.back()" style="height:40px;border-radius: 20px;width: 130px;">Cancel</button>
				</div>
				<div class="col-md-6 col=sm-12">
					<!-- Container for PayPal Shortcut Checkout -->
					<div id="paypal-button-container" style="display:block; margin:0 auto; width: 250px;"></div>
				</div>
			</div>

			<br><br>

		</div>
		<!-- /inner -->
	</div>


	<!-- =========================
		 SCRIPTS
	============================== -->
	<script src="js/jquery.js"></script>
	<script type="text/javascript">

	$(document).ready(function(){
		$('#minterest').on('change', function(e){
			if($(this).is(':checked')){
				$('#minterest_info').not(':animated').slideDown();
			}else{
				$('#minterest_info').not(':animated').slideUp();
			}
		});
	});//$(document).ready(function(){
	function checkCouponCode(t){
		var ccode = $.trim($('#couponCode').val());
		if(ccode.length == 0){
			alert('Please input coupon code.');
			return false;
		}
		$.ajax({
			url : 'data_process.php',
			method : 'POST',
			dataType: "JSON",
			async: false,
			data: { 'paymentmode' : 'couponCheck', 'ccode' : ccode},
			success: function(data){
				if(data.completed == "Y"){
					var _total_price = 0;
					var _dis_total_price = 0;
					var _dis_text = "";
					if(data.cp_type == "A"){
						$.each($('.payment-cart .payment-cart-item'), function(i,v){
							var _cost = $(v).data('cost');
							var _dis_cost = _cost;
							if(data.cp_dc_type == "PE"){
								_dis_cost -= Math.floor(_cost * (data.cp_discount / 100) * 100) / 100;
								_dis_text = " ("+data.cp_discount+"% Coupon Applied)";
							}else if(data.cp_dc_type == "PR"){
								_dis_cost = data.cp_discount;
							}
							// $(v).find('.cost_text').html('<span class="price-discount">$'+_cost+'</span> => $'+_dis_cost);
							_total_price += _cost;
							_dis_total_price += _dis_cost;
						});
					// }else if(data.cp_type == "I"){
					// }else if(data.cp_type == "T"){
					}
					$('.payment-cart .total_cost_text').html('<span class="price-org">$'+_total_price+'</span> <span class="price-discount">$'+_dis_total_price + _dis_text)+"</span>";
					$("#total_price").val(_dis_total_price);

				}else{
					var _total_price = 0;
					$.each($('.payment-cart .payment-cart-item'), function(i,v){
						var _cost = $(v).data('cost');
						// $(v).find('.cost_text').text('$'+ _cost);
						_total_price += _cost;
					});
					$('.payment-cart .total_cost_text').text('$'+_total_price);
					$("#total_price").val(_total_price);
					alert("Invalid coupon code. Please try agian.");
				}
			}
			,beforeSend: function(jqXHR, settings ){
				showLoading();
			}
			,error: function(jqXHR, status, error){
				alert("Coupon apply failure. Please try agian.");
			}
			,complete: function(jqXHR, status){
				hideLoading();
			}
		});

	}
	</script>

	<? include "checkout_paypal_new.php"; ?>
</body>
</html>
