
<!-- =========================
FOOTER SECTION
============================== -->
<footer>
	<div class="container">
		<div class="row">

			<div class="col-md-12 col-sm-12">
				<p class="wow fadeInUp" data-wow-delay="0.6s">Copyright &copy; 2020 KIOSC Training Center | Support by ePASS Solutions</p>

				<ul class="social-icon">
					<li><a href="#" class="fa fa-facebook wow fadeInUp" data-wow-delay="1s"></a></li>
					<li><a href="#" class="fa fa-twitter wow fadeInUp" data-wow-delay="1.3s"></a></li>
					<li><a href="#" class="fa fa-dribbble wow fadeInUp" data-wow-delay="1.6s"></a></li>
					<li><a href="#" class="fa fa-behance wow fadeInUp" data-wow-delay="1.9s"></a></li>
					<li><a href="#" class="fa fa-google-plus wow fadeInUp" data-wow-delay="2s"></a></li>
				</ul>

			</div>

		</div>
	</div>
</footer>

<!------------------------->
<!-- Shopping Cart Modal -->
<!------------------------->
<div class="modal fade" id="modal-data-edit">
	<div class="modal-dialog" id="custom-modal">
		<div class="modal-content">
			<div class="modal-header" style="background-color: #0480be; color: white;">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title" id="modaltitle"></h4>
			</div>
			<div class="modal-body" id="modal-data-edit-body"></div>
		</div>
		<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<!-- Back top -->
<a href="#back-top" class="go-top"><i class="fa fa-angle-up"></i></a>


<script type="text/javascript">
$(document).ready(function(){

	//-------------------------------------------
	// Call Log in
	//-------------------------------------------
	$(document).on('click', 'button.callLogin', function(e){

		var midx = $(this).data('midx');
		var profile = $(this).data('profile');
		var modalHeader = "";

		if(profile == "profile") {
			modalHeader = "MEMBER PROFILE!";
		} else {
			modalHeader = "MEMBER LOGIN!";
		}

		logincall(midx,"",modalHeader);
 	});

	//-------------------------------------------
	// Call Login Modal
	//-------------------------------------------
	function logincall(midx,trcost,modaltitle) {

		$('#custom-modal').removeClass("modal-lg");

		var showEditModal = true;

		if(showEditModal){
			$.ajax({
				method : 'POST',
				url : './login.php',
				dataType : 'html',
				data: { 'm_idx' : midx, 'tr_cost' : trcost },
				success: function(data){
					$('#modaltitle').text(modaltitle);
					$('#modal-data-edit-body').html(data);
					$('#modal-data-edit').modal();
					$.each($('#modal-data-edit select'), function(i,v){
						$(v).select2();
					});
				},
				beforeSend: function(jqXHR, settings ){
					showLoading();
				},
				complete: function(jqXHR, status){
					hideLoading();
				},
				error: function(data){
				}
			});
		}
	}//editcall

	//-------------------------------------------
	// Remove to Cart
	//-------------------------------------------
	$(document).on('click', 'button.btn-cart-remove', function(e){
		var _this = $(this);
		var _row  = _this.closest('tr.cart-item');
		var tr_idx = _row.data('trIdx');
		var cart_idx = _row.data('cartIdx');

		if(confirm('Remove cart item?')){
			$.ajax({
				method : 'POST',
				url : './data_process.php',
				dataType : 'json',
				data: { 'cartmode': 'deleteOne','tr_idx' : tr_idx, 'cart_idx' : cart_idx },
				success: function(data){
					if(data.complete == 'Yes'){
						_row.remove();
						$('button.addtocart[data-tridx='+ data.sub_data.tr_idx +']').text("Add to Cart").prop('disabled', false);

						// Total re cal
						var totalPrice = 0;
						$.each($('#cart tr.cart-item'), function(i,v){
							totalPrice += $(v).data('cost');
						});
						$('#cart span.cart_total_price').text(totalPrice);
						// cart recount
						var cartCount = $('ul.nav li button.addtocart span').text();
						var new_cartCount = cartCount - 1;
						if(new_cartCount == 0){
							$('ul.nav li button.addtocart span').text('');
						}else{
							$('ul.nav li button.addtocart span').text(new_cartCount);
						}

					}else{
						if(data.message != ''){
							alert(data.message);
						}else{
							alert('Cart item delete fail. Please try again.');
						}
					}
				},
				beforeSend: function(jqXHR, settings ){
					showLoading();
				},
				complete: function(jqXHR, status){
					hideLoading();
				},
				error: function(data){
					alert('Cart item delete fail. Please try again.');
				}

			});
		}

	});

});
</script>
