<?php
include_once "inc/common.php";


// --------------------------------
// Check Login Status
// --------------------------------
$s_m_idx  = $_SESSION[SESSION_ID."_idx"];
$s_m_id   = $_SESSION[SESSION_ID."_id"];
$s_m_name = $_SESSION[SESSION_ID."_name"];

// --------------------------------
// Cart Count
// --------------------------------
if (! empty($_SESSION["shopping_cart"])) {
	$cart_count = count(array_keys($_SESSION["shopping_cart"]));
}

// --------------------------------
// Get Training information
// --------------------------------
$SQL = "SELECT * FROM training WHERE tr_open = 'Open' ORDER BY tr_order ASC; ";
$Result = mysqli_query($conn, $SQL);

$i = 0;
while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {

	$db_tr_idx[$i]        = $ResultsRow[tr_idx];
	$db_tr_date[$i]       = stripslashes($ResultsRow[tr_date]);
	$db_tr_webex[$i]      = stripslashes($ResultsRow[tr_webex]);
	$db_tr_instructor[$i] = stripslashes($ResultsRow[tr_instructor]);
	$db_tr_instructor_pic[$i] = stripslashes($ResultsRow[tr_instructor_pic]);
	$db_tr_title[$i] = stripslashes($ResultsRow[tr_title]);
	$db_tr_desc[$i] = stripslashes($ResultsRow[tr_desc]);
	$db_tr_cost[$i] = stripslashes($ResultsRow[tr_cost]);
	$db_tr_open[$i] = stripslashes($ResultsRow[tr_open]);
	$db_tr_cat[$i] = stripslashes($ResultsRow[tr_cat]);
	$db_tr_oder[$i] = stripslashes($ResultsRow[tr_oder]);
	$db_tr_overview_link[$i] = stripslashes($ResultsRow[tr_overview_link]);
	$db_tr_duration[$i] = stripslashes($ResultsRow[tr_duration]);
	$i ++;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-136145973-6"></script>
	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());

		gtag('config', 'UA-136145973-6');
	</script>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>KIOSC TOWN - Training</title>

		<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
		<link rel="icon" href="favicon.ico" type="image/x-icon">

		<!-- Font Icon -->
		<link rel="stylesheet" href="fonts/material-design-iconic-font/css/material-design-iconic-font.min.css">

		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/animate.css">
		<link rel="stylesheet" href="css/font-awesome.min.css">
		<link rel="stylesheet" href="css/owl.theme.css">
		<link rel="stylesheet" href="css/owl.carousel.css">

    <!-- Main css -->
    <link rel="stylesheet" href="css/style_training.css">

</head>
<body>

    <div class="main">

        <div class="container">
            <div class="signup-content">
                <div class="signup-img">
                    <img src="images/training-form-img.jpg" alt="">
                    <div class="signup-img-content">
                        <font style="font-size: 20px; color: white; ">Welcome to KIOSC TOWN!</font>
                        <font style="font-size: 40px; color: white; ">TRAINING</font>
                        <p>While seats are available!</p>
                    </div>
                </div>
                <div class="signup-form">

										<div class="top-menu" id="top-menu">


											<table>
												<tr>
													<td width="70%">
														<font style="font-size: 20px;"><b>Training in KIOSC TOWN</b></font><br>
														<i>Various professional topics, designed to expand and sharpen your skills towards a more successful career.</i>
													</td>
													<td width="30%" align="right">

														<?php
															// Login Status (False)
															if ($s_m_name == "") {
														?>

																<div style="padding-top: 17px;">
																	<a href="membership.php">Membership!</a>&nbsp;&nbsp;
																	<button class="btn btn-sm btn-primary callLogin">Log In</button>
																</div>

														<?php
															// Login Status (True)
															} else if ($s_m_name != "") {
														?>

																<div style="padding-top: 17px;">
																	<button class="btn btn-sm btn-primary callLogin" data-profile="profile" data-midx="<?=$s_m_idx?>">Welcome! <?=$s_m_name?></button>
																	<button class="btn btn-sm btn-warning addtocart">
																		<i class="fa fa-shopping-cart"></i> Cart <span id="counter" class="badge badge-light"><?=$cart_count?></span>
																	</button>
																</div>

														<? } ?>


													</td>
												</tr>
											</table>
										</div>

                    <form method="POST" class="register-form" id="register-form">

											<div role="tabpanel" class="tab-pane active" id="fday">
											<?php
											for ($i = 0; $i < count($db_tr_idx); $i ++) {
											?>

											<!-- program speaker here -->
												<div class="col-md-2 col-sm-2">
													<img src="<?=$db_tr_instructor_pic[$i]?>" style="border-radius: 50%; margin-top: 25px;">
												</div>
												<div class="col-md-10 col-sm-10">
													<h6>
														<span><i class="fa fa-clock-o"></i> <?=$db_tr_date[$i]?></span>
														<span><i class="fa fa-map-marker"></i> <a href="<?=$db_tr_webex[$i]?>" target="_blank">WebEx - <?=$db_tr_webex[$i]?></a></span>
													</h6>
													<h3><?=$db_tr_title[$i]?></h3>
													<font style="font-size: 12px; color: #9c9c9c;">By <?=$db_tr_instructor[$i]?></font>
													<p style="font-size: 12px; color: #9c9c9c;"><?=$db_tr_desc[$i]?></p>
													<h4>* Cost: $<?=$db_tr_cost[$i]?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* Duration: <?=$db_tr_duration[$i]?></h4>

													<!-- Add to Cart Button -->
													<button type="button" class="btn btn-primary addtocart" data-tridx="<?=$db_tr_idx[$i]?>" data-trcost="<?=$db_tr_cost[$i]?>">Add to Cart</button>
													<br><br>
												</div>

												<!-- program divider -->
												<div class="program-divider col-md-12 col-sm-12"></div>

											<? } ?>
											</div>
											<!-- End Training -->



											<!--
                        <div class="form-row">
                            <div class="form-group">
                                <div class="form-input">
                                    <label for="first_name" class="required">First name</label>
                                    <input type="text" name="first_name" id="first_name" required/>
                                </div>
                                <div class="form-input">
                                    <label for="last_name" class="required">Last name</label>
                                    <input type="text" name="last_name" id="last_name" />
                                </div>
                                <div class="form-input">
                                    <label for="company" class="required">Company</label>
                                    <input type="text" name="company" id="company" />
                                </div>
                                <div class="form-input">
                                    <label for="email" class="required">Email</label>
                                    <input type="text" name="email" id="email" />
                                </div>
                                <div class="form-input">
                                    <label for="phone_number" class="required">Phone number</label>
                                    <input type="text" name="phone_number" id="phone_number" />
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="form-select">
                                    <div class="label-flex">
                                        <label for="meal_preference">meal preference</label>
                                        <a href="#" class="form-link">Lunch detail</a>
                                    </div>
                                    <div class="select-list">
                                        <select name="meal_preference" id="meal_preference">
                                            <option value="Vegetarian">Vegetarian</option>
                                            <option value="Kosher">Kosher</option>
                                            <option value="Asian Vegetarian">Asian Vegetarian</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-radio">
                                    <div class="label-flex">
                                        <label for="payment">Payment Mode</label>
                                        <a href="#" class="form-link">Payment Detail</a>
                                    </div>
                                    <div class="form-radio-group">
                                        <div class="form-radio-item">
                                            <input type="radio" name="payment" id="cash" checked>
                                            <label for="cash">Cash</label>
                                            <span class="check"></span>
                                        </div>
                                        <div class="form-radio-item">
                                            <input type="radio" name="payment" id="cheque">
                                            <label for="cheque">Cheque</label>
                                            <span class="check"></span>
                                        </div>
                                        <div class="form-radio-item">
                                            <input type="radio" name="payment" id="demand">
                                            <label for="demand">Demand Draf</label>
                                            <span class="check"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-input">
                                    <label for="chequeno">DD / Cheque No.</label>
                                    <input type="text" name="chequeno" id="chequeno" />
                                </div>
                                <div class="form-input">
                                    <label for="blank_name">Drawn on ( Bank Name)</label>
                                    <input type="text" name="blank_name" id="blank_name" />
                                </div>
                                <div class="form-input">
                                    <label for="payable">Payable at</label>
                                    <input type="text" name="payable" id="payable" />
                                </div>
                            </div>
                        </div>

                        <div class="form-submit">
                            <input type="submit" value="Submit" class="submit" id="submit" name="submit" />
                            <input type="submit" value="Reset" class="submit" id="reset" name="reset" />
                        </div>
											-->
                    </form>
                </div>
            </div>
        </div>


				<!------------------------->
				<!-- Shopping Cart Modal -->
				<!------------------------->
				<div class="modal fade" id="modal-data-edit">
					<div class="modal-dialog" id="custom-modal">
						<div class="modal-content">
							<div class="modal-header" style="background-color: #0480be; color: white;">
								<button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
								<h4 class="modal-title" id="modaltitle"></h4>
							</div>
							<div class="modal-body" id="modal-data-edit-body"></div>
						</div>
						<!-- /.modal-content -->
					</div>
					<!-- /.modal-dialog -->
				</div>
				<!-- /.modal -->






    </div>



		<!-- =========================
			 SCRIPTS
		============================== -->
		<script src="js/jquery.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.parallax.js"></script>
		<script src="js/owl.carousel.min.js"></script>
		<script src="js/smoothscroll.js"></script>
		<script src="js/wow.min.js"></script>
		<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
		<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.10.20/js/dataTables.bootstrap.min.js"></script>
		<script src="js/training_main.js"></script>

		<script type="text/javascript">

		$(document).ready(function(){


			//-------------------------------------------
			// Call Log in
			//-------------------------------------------
			$(document).on('click', 'button.callLogin', function(e){

				var midx = $(this).data('midx');
				var profile = $(this).data('profile');
				var modalHeader = "";

				if(profile == "profile") {
					modalHeader = "MEMBER PROFILE!";
				} else {
					modalHeader = "MEMBER LOGIN!";
				}

				logincall(midx,"",modalHeader);
		 	});

			//-------------------------------------------
			// Call Login Modal
			//-------------------------------------------
			function logincall(midx,trcost,modaltitle) {

				$('#custom-modal').removeClass("modal-lg");

				var showEditModal = true;

				if(showEditModal){
					$.ajax({
						method : 'POST',
						url : './login.php',
						dataType : 'html',
						data: { 'm_idx' : midx, 'tr_cost' : trcost },
						success: function(data){
							$('#modaltitle').text(modaltitle);
							$('#modal-data-edit-body').html(data);
							$('#modal-data-edit').modal();
							$.each($('#modal-data-edit select'), function(i,v){
								$(v).select2();
							});
						},
						error: function(data){
						}
					});
				}
			}//editcall


			//-------------------------------------------
			// Add to Cart
			//-------------------------------------------
			$(document).on('click', 'button.addtocart', function(e){

				var tridx = $(this).data('tridx');
				var trcost = $(this).data('trcost');

				if(tridx == "") {
					editcall("","","SHOPPING CART!");
				} else {
					editcall(tridx,trcost,"SHOPPING CART!");
				}
			});

			//-------------------------------------------
			// Add to Cart Call
			//-------------------------------------------
			function editcall(tridx,trcost,modaltitle) {

				$('#custom-modal').addClass("modal-lg");

				var showEditModal = true;

				if(showEditModal){
					$.ajax({
						method : 'POST',
						url : './cart.php',
						//dataType : 'html',
						data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
						success: function(data){
							$('#modaltitle').text(modaltitle);
							$('#modal-data-edit-body').html(data);
							$('#modal-data-edit').modal();
							$.each($('#modal-data-edit select'), function(i,v){
								$(v).select2();
							});
						},
						error: function(data){
						}
					});
				}
			}//editcall


			//-------------------------------------------
			// Remove to Cart
			//-------------------------------------------
			$(document).on('click', 'button.btn-cart-remove', function(e){
				var _this = $(this);
				var _row  = _this.closest('tr.cart-item');
				var tr_idx = _row.data('trIdx');
				var cart_idx = _row.data('cartIdx');

				if(confirm('Do you want to remove this item?')){
					$.ajax({
						method : 'POST',
						url : './data_process.php',
						dataType : 'json',
						data: { 'cartmode': 'deleteOne','tr_idx' : tr_idx, 'cart_idx' : cart_idx },
						success: function(data){
							if(data.complete == 'Yes'){
								_row.remove();
								// Total re cal
								var totalPrice = 0;
								$.each($('#cart tr.cart-item'), function(i,v){
									totalPrice += $(v).data('cost');
								});
								$('#cart span.cart_total_price').text(totalPrice);
								// cart recount
								var cartCount = $('button.addtocart span').text();
								$('button.addtocart span').text(cartCount - 1);

							}else{
								if(data.message != ''){
									alert(data.message);
								}else{
									alert('Cart item delete fail. Please try again.');
								}
							}
						},
						error: function(data){
							alert('Cart item delete fail. Please try again.');
						}
					});
				}

			});


		});

		</script>





</body>
</html>
