<?php
include_once "inc/common.php";
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<title>KIOSC - Membership Registration</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<!-- MATERIAL DESIGN ICONIC FONT -->
		<link rel="stylesheet" href="fonts/material-design-iconic-font/css/material-design-iconic-font.min.css">

		<!-- STYLE CSS -->
		<link rel="stylesheet" href="css/style_membership.css">
	</head>

	<body>

		<div class="wrapper" style="background-image: url('images/bg-registration-form-2.jpg');">
			<div class="inner">

				<!-- Membership Benefits -->
				<div class="notice">
					<h2 align="center">Membership Benefits</h2><br><br>
					<b>INDIVIDUAL MEMBERSHIP</b><br>
 					  - KIOSC Contents Free Access<br>
 						- KIOSC Paid Service Discount<br>
 						- KIOSC Newsletter Provided<br>
					<br>
					<b>BUSINESS MEMBERSHIP</b><br>
 					- Included All Individual Membership Benefits<br>
 					- Business Advertising<br>
 					- Launch Webminar in the KIOSC TOWN<br>
					<br>
					<p style="font-size: 17px; text-align: center;">
						<!--<font size="15px">&ldquo;</font>-->
						"All membership fees will be waived<br>
						during the promotional period <br>
						ending on December 31, 2020 in order <br>
						to show you everything KIOSC has to offer."
						<!--<font size="15px">&ldquo;</font>-->
				</div>

				<form class="member-form" id="member-form" action="data_process.php" method="post">

					<input type="hidden" name="membermode" value="memberregister">
					<input type="hidden" name="fpage" value="training">

					<h3>Registration Form</h3>
					<div class="form-group">
						<div class="form-wrapper">
							<label for="">Username</label>
							<input type="text" class="form-control" id="mid" name="mid" required>
							<div id="user-availability-status" style="color: #9e251c;"></div>
						</div>
						<div class="form-wrapper">
							<label for="">Full Name</label>
							<input type="text" class="form-control" id="mname" name="mname" required>
							<div id="nameerror" style="color: #9e251c;"></div>
						</div>
					</div>
					<div class="form-group">
						<div class="form-wrapper">
							<label for="">Password</label>
							<input type="password" class="form-control" id="mpw" name="mpw" required>
						</div>
						<div class="form-wrapper">
							<label for="">Confirm Password</label>
							<input type="password" class="form-control" id="mpwconfirm"  name="mpwconfirm" required>
							<div id="error" style="color: #9e251c;"></div>
						</div>
					</div>
					<div class="form-wrapper">
						<label for="">Email</label>
						<input type="text" class="form-control" id="memail" name="memail" required>
						<div id="emailerror" style="color: #9e251c;"></div>
					</div>
					<div class="form-wrapper">
						<label for="">Membership Type</label>
							<?echo getMembershipType($s_m_cat);?>
							<div id="typeerror" style="color: #9e251c;"></div>
					</div>
					<div class="form-wrapper">
						<label for="">Country</label>
							<?echo getCountry($s_m_country);?>
							<div id="countryerror" style="color: #9e251c;"></div>
					</div>
					<div class="checkbox">
						<label>
							<input type="checkbox"> I accept the Terms of Use & Privacy Policy.
							<span class="checkmark"></span>
						</label>
					</div>
					<button type="button" class="callMembership">Register Now</button>
				</form>
			</div>
		</div>


		<!-- =========================
			 SCRIPTS
		============================== -->
		<script src="js/jquery.js"></script>
		<script type="text/javascript">

		$(document).ready(function(){

			//--------------------------
			//Realtime Username Check
			//--------------------------
			$("#mid").focusin(function(){
  			$("#user-availability-status").text("");
			});
			$("#mid").blur(function(){
				var mid = $(this).val();
				$.ajax({
					url : 'username_check.php',
					method : 'POST',
					data: { 'username' : mid },
					success: function(data){
						$("#user-availability-status").text(data);
					}
				});
			});

			//------------------------
			// Fullname Error reset
			//------------------------
			$("#mname").focusin(function(){
  			$("#nameerror").text("");
			});

			//-------------------------
			// Membertype Error Reset
			//-------------------------
			$("#mcat").focusin(function(){
  			$("#typeerror").text("");
			});

			//-------------------------
			// Couuntry Error Reset
			//-------------------------
			$("#mcountry").focusin(function(){
  			$("#countryerror").text("");
			});

			//--------------------------
			// Password Confirm
			//--------------------------
			$("#mpwconfirm").focusin(function(){
  			$("#error").text("");
			});
			$("#mpwconfirm").focusout(function(){
				var mpw = $("#mpw").val();
				var mpwconfirm = $("#mpwconfirm").val();
				if(mpw != mpwconfirm) {
					$("#error").text("Doesn't match!");
					return false;
				}

			});

			//----------------------
			// Email Error Reset
			//----------------------
			$("#memail").focusin(function(){
  			$("#emailerror").text("");
			});

			//-------------------------------------------
			// Submit Membership
			//-------------------------------------------
			$(document).on('click', 'button.callMembership', function(e){

				var mid = $("#mid").val();
				var mname = $("#mname").val();
				var mpw = $("#mpw").val();
				var mpwconfirm = $("#mpwconfirm").val();
				var memail = $("#memail").val();
				var mcat = $("#mcat").val();
				var mcountry = $("#mcountry").val();
				var chkuserid = "";
				//Username availability
				$.ajax({
					url : 'username_check.php',
					method : 'POST',
					data: { 'username' : mid },
					success: function(data){
						$("#user-availability-status").text(data);
						if(data === "") {
							chkuserid = "Yes";
						} else {
							chkuserid = "No";
						}
					},
					async: false
				});

				//Username exists
				if(chkuserid === "No") {
					alert("Username is already exists!");
					return false;
				}

				//Fullname validation
				if(mname === "") {
					$("#nameerror").text("Fullname is required!");
					return false;
				}

				//Password Confirmation
				if(mpw != mpwconfirm) {
					$("#error").text("Doesn't match!");
					return false;
				}

				//Email validation
				if(memail === "") {
					$("#emailerror").text("Email is required");
					return false;

				} else {

					if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(memail)) {

  				} else {
						$("#emailerror").text("Invalid email address");
    				//alert("You have entered an invalid email address!")
    				return (false);
					}

				}

				//Member Category
				if(mcat === "") {
					$("#typeerror").text("Membership Type is required!");
					return false;
				}

				//Member Country
				if(mcountry === "") {
					$("#countryerror").text("Member Country is required!");
					return false;
				}


				//Form submit
				$('form#member-form').submit();



			});

		});//$(document).ready(function(){

		</script>


	</body>
</html>
