<?
include "PayPalApi/Config/Config.php";

?>

<!-- Javascript Import -->
<script src="https://www.paypal.com/sdk/js?client-id=<?=PAYPAL_CREDENTIALS[PAYPAL_ENVIRONMENT][client_id]?>"></script>


<!-- PayPal In-Context Checkout script -->
<script type="text/javascript">
$(document).ready(function(){
	//------------------------
	// Fullname Error reset
	//------------------------
	$("#mname").focusin(function(){
		$("#nameerror").text("");
	});

	//-------------------------
	// Email Error Reset
	//-------------------------
	$("#memail").focusin(function(){
		$("#emailerror").text("");
	});

});

function checkValidation(){
	var mname      = $.trim($("#mname").val());
	var memail     = $.trim($("#memail").val());
	var mComName   = $.trim($("#mcompany").val());
	var minterest  = $("#minterest").is(":checked") ? "Y" : "N";
	var mreceve    = $("#mreceve").is(":checked") ? "Y" : "N";

	var cartIdx = "";
	$.each($('.payment-cart .payment-cart-item'), function(i,v){
		var _idx = $(v).data('idx');
		cartIdx += (cartIdx == "" ? _idx : ","+ _idx);
	});

	if(cartIdx == ""){
		alert('No Cart Item');
		return false;
	}

	if(mname.length == 0){
		$("#nameerror").text("Fullname is required!");
		return false;
	}

	if(memail.length == 0){
		$("#emailerror").text("Email is required");
		return false;

	} else {
		if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(memail)) {

		} else {
			$("#emailerror").text("Invalid email address");
			//alert("You have entered an invalid email address!")
			return (false);
		}
	}

	return true;
}



paypal.Buttons({
	// Set your environment
	env: '<?= PAYPAL_ENVIRONMENT ?>',

	// Set style of button
	style: {
		layout:  'horizontal',
		color:   'gold',
		shape:   'pill',
		label:   'checkout',
		tagline: false,
		height: 40
	},

	onClick: function(data, actions){
		// validation check
		if(checkValidation()){
			showLoading();
			return true;
		}else{
			return false;
		}
	}
	, createOrder: function(data, actions) {

		// This function sets up the details of the transaction, including the amount and line item details.
		return actions.order.create({
			intent: "CAPTURE",
			application_context: { shipping_preference: "NO_SHIPPING" },
			purchase_units: [{
				amount: {
					value: $('#total_price').val()
				}
			}]
		});

	}
	, onApprove: function(data, actions) {
		// This function captures the funds from the transaction.
		return actions.order.capture().then(function(details) {
			details['paymentmode'] = "payment";
			details['mname']       = $.trim($("#mname").val());
			details['memail']      = $.trim($("#memail").val());
			details['mcompany']    = $.trim($("#mcompany").val());
			details['minterest']   = $("#minterest").is(":checked") ? "Y" : "N";
			details['mreceve']     = $("#mreceve").is(":checked") ? "Y" : "N";
			details['couponCode']  = $.trim($("#couponCode").val());

			$.ajax({
				url : 'data_process.php',
				method : 'POST',
				async: false,
				data: details,
				success: function(data){
					alert('Thanks for your order.\nWe will send you a confirmation email soon.');
					location.href = "checkout_completed.php";
				}
				,beforeSend: function(jqXHR, settings ){
				}
				,error: function(jqXHR, status, error){
					alert('Checkout Error,\nPlease contact us.');
				}
				,complete: function(jqXHR, status){
				}
			});
		});
	}
	, onCancel: function (data) {
		hideLoading();
		// Show a cancel page, or return to cart
	}
	, onError: function (err) {
		hideLoading();
		// Show an error page here, when an error occurs
	}

}).render('#paypal-button-container');

</script>
