<?php
include_once "inc/common.php";

// $_SESSION[SESSION_ID."pm_id"] = "7WS38450EW5368529";

$pm_id = $_SESSION[SESSION_ID."pm_id"];

if(empty($pm_id)){
	echo "<meta http-equiv='Refresh' content='0; URL=training_original.php'>";
	echo "<script>alert('Did Not Payment information.');</script>";
	// exit;
}


include_once "data_process_payment_fn.php";

$payment = getPaymentDataByPMID($pm_id, $conn);

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title>KIOSC - Course Registration</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<!-- MATERIAL DESIGN ICONIC FONT -->
	<link rel="stylesheet" href="fonts/material-design-iconic-font/css/material-design-iconic-font.min.css">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- STYLE CSS -->
	<link rel="stylesheet" href="css/style_checkout.css?v=2020051401">

	<script src="js/jquery.js"></script>
	<script src="js/checkout.js"></script>

</head>
<body>

	<div class="wrapper" style="background-image: url('images/bg-registration-form-2.jpg');">
		<div class="inner">

			<h3>Registration Completed</h3>
			<div class="registeration-info">
				<div class="t-row">
					<div class="t-cell tc-center" style="width: 100%;">
						<p><strong>Thank you for your order from the</strong></p>
						<p><strong>KIOSC Training Center!</strong></p>
					</div>
				</div>
			</div>

			<div class="cartinfo">
				<br>
				<b>Checkout Course Information</b>
				<table class="table table-striped payment-cart" style="font-size:14px;width:100%;border-collapse: collapse;">
					<tr style="border-bottom: 1px solid #dddddd;">
						<td>Description</td>
						<td>Cost</td>
					</tr>
					<? foreach ($payment[training] as $training) { ?>
					<tr class="payment-cart-item" style="border-bottom: 1px solid #dddddd;">
						<td><?=$training[tr_title]?></td>
						<td class="cost_text">
							<?
							if($payment['pm_currency_code'] == "KRW"){
								echo number_format($training['tr_cost']);
							}else{
								echo "$".$training['tr_cost'];
							}
							?>
						</td>
					</tr>
					<? } ?>
					<tr style="font-size:16px;">
						<td>Total Cost</td>
						<td class="total_cost_text"><strong>
							<?
							if($payment['pm_currency_code'] == "KRW"){
								echo number_format($payment['pm_pre_amount']);
							}else{
								echo "$".$payment['pm_pre_amount'];
							}
							?>
							</strong>
						</td>
					</tr>
				</table>
			</div>
			<br><br>


			<div class="registeration-info">
				<? if($payment['pm_discount'] > 0){ ?>
				<div class="t-row">
					<div class="t-cell tc-right"  style="font-size:20px;width: 75%;"> Discount </div>
					<div class="t-cell tc-center" style="font-size:20px;width:  3%;"> : </div>
					<div class="t-cell tc-left"   style="font-size:20px;width: 22%;">
						<?
						if($payment['pm_currency_code'] == "KRW"){
							echo number_format($payment['pm_discount']);
						}else{
							echo "$".$payment['pm_discount'];
						}
						?>
					</div>
				</div>
				<? } ?>
				<div class="t-row">
					<div class="t-cell tc-right"  style="font-size:20px;width: 75%;"> Total Checkout </div>
					<div class="t-cell tc-center" style="font-size:20px;width:  3%;"> : </div>
					<div class="t-cell tc-left"   style="font-size:20px;width: 22%;">
						<?
						if($payment['pm_currency_code'] == "KRW"){
							echo number_format($payment['pm_amount']);
						}else{
							echo "$".$payment['pm_amount'];
						}
						?>
					</div>
				</div>
			</div>

			<!-- Checkout Options -->
			<div class="form-group" style="padding: 45px 45px 0px 45px;">
				<div class="col-md-6 col=sm-12" style="text-align: left; padding-left:50px;">
					<button class="btn btn-danger" type="button" onclick="location.href='index_new.php'" style="height:40px;border-radius: 20px;width: 130px;">Close</button>
				</div>
				<div class="col-md-6 col=sm-12" style="text-align: right; padding-right:50px;">
					<button class="btn btn-primary" type="button" onclick="sendReceipt()" style="height:40px;border-radius: 20px;width: 200px;">Send Receipt</button>
				</div>
			</div>

			<br><br>

		</div>
		<!-- /inner -->
	</div>


	<!-- =========================
		 SCRIPTS
	============================== -->
	<script type="text/javascript">
	$(document).ready(function(){
	});//$(document).ready(function(){
	function sendReceipt(){
		$.ajax({
			url : 'data_process.php',
			method : 'POST',
			async: false,
			data: { 'paymentmode':'sendReceipt'},
			success: function(data){
				alert('Email send completed');
				location.href = "training_original.php";
			}
			,beforeSend: function(jqXHR, settings ){
				showLoading();
			}
			,error: function(jqXHR, status, error){
				alert("Send Receipt Error. Please try again.");
			}
			,complete: function(jqXHR, status){
				hideLoading();
			}
		});
	}
	</script>

</body>
</html>
